#include <iostream>
#include <sstream>
#include "Gui.h"
#include "TCanvas.h"
#include "TROOT.h"
#include "TStyle.h"
#include "TAxis.h"
#include "TAttAxis.h"
#include "TText.h"
#include "TTimer.h"
#include <TGButton.h>
#include <TRootEmbeddedCanvas.h>

extern MyMainFrame* mf;
extern int iclst;
extern char *clusters[];

//=====================================================================
GCluster::GCluster(TGCompositeFrame *topframe, UInt_t p, UInt_t w,
                   char *aname) : npoints(20), tpoints(0),
                   name(0), data(0), ftop(topframe), fC(0), button(0),
                   fCheckBox(0), binps(0)
{
   name = StrDup(aname);
   // Initialise graphs
   for (int i=0;i<NITEMS;i++) {
      graphs[i]=0;
      show[i]=1;
      names[i]=0;
   }
   show[NITEMS-1]=0;
   fC = new TRootEmbeddedCanvas("fC",ftop,p,w);
   ftop->AddFrame(fC,new TGLayoutHints(kLHintsExpandX | kLHintsExpandY,1,1,1,1));
   button = new TGTextButton(ftop,name);
   button->Connect("Clicked()","GCluster",this,"CheckBox()");
   ftop->AddFrame(button, new TGLayoutHints(kLHintsCenterX,5,5,3,4));
}

void GCluster::Choose()
{
   for (int i=0;i<NITEMS;i++) if (binps[i]) {
      show[i] = binps[i]->GetState();
      //cout << i << " showinps " << showinps[i] << endl;
   }
}

void GCluster::CheckBox()
{
   cout << "Input check box" << endl;
   binps = new TGCheckButton *[NITEMS];
   fCheckBox = new TGMainFrame(gClient->GetRoot(),20,20);
   TGVerticalFrame *vframe = new TGVerticalFrame(fCheckBox,40,200);
   for (int i=0;i<NITEMS;i++) {
      binps[i]=0;
      if (graphs[i]) {
         binps[i] = new TGCheckButton(vframe,names[i],1);
         binps[i]->Connect("Toggled(Bool_t)", "GCluster", this,"Choose()");
         binps[i]->SetState(kButtonDown);
         vframe->AddFrame(binps[i], new TGLayoutHints(kLHintsCenterX,5,5,3,4));
      }
   }
   fCheckBox->AddFrame(vframe, new TGLayoutHints(kLHintsCenterX,2,2,2,2));
   fCheckBox->SetWindowName("Select INPUTS");
   fCheckBox->MapSubwindows();
   fCheckBox->Resize(fCheckBox->GetDefaultSize());
   fCheckBox->MapWindow();
}

void GCluster::DoDraw()
{
   cout << "kreslim " << name << endl;
   if (!data) {
      cout << "Cluster " << name << " Internal error, data=0" << endl;
      return;
   }
   //
   tpoints++;
   int ncd=0;
   for (int i=0;i<NITEMS;i++) {
      if (data[i] && show[i]) {
         if (graphs[i]) delete graphs[i];
         if (tpoints>npoints) tpoints=npoints;
         // Time on x axes
         //TGraph *f1 = new TGraph(tpoints,dataInp[NINP],dataInp[i]);
         // rate on X axes
         //TGraph *f1 = new TGraph(tpoints,dataInp[i],dataInp[NINP]);
         double *ex = new double[tpoints];
         double *ey = new double[tpoints];
         for (int j=0;j<tpoints;j++) {
            ey[j]=0.;
            ex[j]=data[i][j]/10.;
         }
         TGraphErrors *f1 = new TGraphErrors(tpoints,data[i],data[NITEMS-1],ex,ey);
         // swapped x and y axes on TGraphErrors to have time on bottom
         //TGraphErrors *f1 = new TGraphErrors(tpoints,dataInp[NINP],dataInp[i],ey,ex);
         char time[30];
         strcpy(time,"lalal");
         //cout << time << endl;
         f1->GetXaxis()->SetNdivisions(401,kTRUE);
         f1->GetYaxis()->SetNdivisions(-410,kFALSE);
         f1->GetXaxis()->SetNoExponent();
         //f1->GetYaxis()->LabelsOption("v"); // doesn't work as labels "don't exist" for the graph y axis, only values
         f1->GetYaxis()->SetTimeDisplay(1);
         f1->GetYaxis()->SetTimeFormat("%H:%M");
         f1->SetMarkerColor(1+(ncd%4));
         f1->SetMarkerStyle(20+(ncd%4));
         f1->SetTitle(names[i]);
         //f1->GetXaxis()->SetDecimals(0);
         if (i==0) {
            //f1->GetYaxis()->SetLabelSize(0.12);
            //f1->GetYaxis()->SetLabelOffset(1);
            f1->GetYaxis()->SetTitle("Time(min)");
            f1->GetYaxis()->SetTitleSize(0.1);
            f1->GetYaxis()->SetTitleOffset(-4.75);
         }
         // set x axis range for good positioning of labels
         float min, max;
         for (int k=0; k<tpoints; k++) {
            if (k==0) {
               min = data[i][k];
               max = data[i][k];
            }
            if (data[i][k] > max) max = data[i][k];
            if (data[i][k] < min) min = data[i][k];
         }
         //float extr = max-min ? (max-min)*0.1 : 1;
         // if (max==min && min==0) f1->GetXaxis()->SetRangeUser(-0.05,1.05);
         //else f1->GetXaxis()->SetRangeUser( int(min-extr), int(max+extr)+1);
         //f1->GetXaxis()->SetRangeUser(0,5);
         //Double_t  maxr = 1.0;
         //Double_t  minr = 0.0;
         //Double_t  extr = maxr-minr ? (maxr-minr)*0.1 : 1 ;
         //f1->Draw("axp");
         graphs[i] = f1;
         ncd++;
         //break;
      }
   }
   TCanvas *fCanvas = fC->GetCanvas();
   cout << "TCanvas got from fC" << endl;
   //if (tpoints==1)fCanvas->Divide(1,ncd);
   //gStyle->SetFrameBorderSize(0);
   cout << "fcanvas= " << fCanvas << endl;
   fCanvas->Clear();
   // Divide(nx,ny,xmargin,ymargin,color),
   fCanvas->Divide(ncd,1,0.0025,0.0025,0);
   cout << "Canvas divided" << endl;
   for (int i=0; i<ncd; i++) {
      fCanvas->GetPad(i+1)->SetGridy(1);
      if (i==0) {
         //fCanvas->GetPad(i+1)->SetLeftMargin(0.3);
      }
   }
   fCanvas->SetGridy(1);
   ncd=0;
   TText* timelabel = new TText(.050,0.5,"Time(s)");
   timelabel->SetNDC();
   timelabel->SetTextAngle(90);
   for (int i=0;i<NITEMS;i++) {
      if (graphs[i] && show[i]) {
         ncd++;
         fCanvas->cd(ncd);
         //graphsInps[i]->Draw("alp");
         graphs[i]->Draw("ap");
         //timelabel->Draw();
         //break;
      }
   }
   // Copy to MONSCAL for html display
   fCanvas->SaveAs("inputs.png");
   stringstream ss ;
   ss << "scp inputs.png trigger@alidcscom026:v/vme/WORK/MONSCAL/.";
   //int rc=system((ss.str()).c_str());
   //cout  << ss.str() << " rc= " << rc << endl;
   fCanvas->Update();
}

GCluster::~GCluster()
{
   // remove frames (widgets) from the list of their parent
   ftop->RemoveFrame(fC);
   ftop->RemoveFrame(button);
   // reparent the widgets to the root window, so they can 
   // be properly destroyed
   fC->ReparentWindow(gClient->GetDefaultRoot());
   button->ReparentWindow(gClient->GetDefaultRoot());
   // and finally delete them
   delete fC;
   delete button;
}

//======================================================================
MyMainFrame::MyMainFrame(const TGWindow *p,UInt_t w,UInt_t h) :
   fMain(0), fComp(0), fInputs(0), exit(0), nclust(0), numofruns(0)
{
   // Xero fCluster
   for (int i=0;i<6;i++) fCluster[i]=0;
   // Create a main frame
   fMain = new TGMainFrame(p,w,h);
   // composite fram
   AddCompFrame();
   //
   AddInputs();
   SetGlobalRootVars();
   AddExit();
   // Set a name to the main frame
   fMain->SetWindowName("CTP");
   //
   ShowIt();
}

void MyMainFrame::SetNpoints(int np)
{
   fInputs->SetNpoints(np);
   for (int i=0;i<nclust;i++) fCluster[i]->SetNpoints(np);
}

void MyMainFrame::TimerAddCluster()
{
   // timer used to add a cluster via the main thread
   if (iclst < 5) {
      TTimer::SingleShot(10, "MyMainFrame", this, "AddCluster()");
   }
}

void MyMainFrame::TimerDelCluster()
{
   // timer used to remove a cluster via the main thread
   if (iclst > 0) {
      TTimer::SingleShot(10, "MyMainFrame", this, "RemoveCluster()");
   }
}

GCluster* MyMainFrame::AddCluster(char* name)
{
   fCluster[nclust] = new GCluster(fComp,1200,200+(nclust+1)*200,name);
   //fComp->MoveResize(0,0,1200,200+(nclust+1)*200);
   nclust++;
   cout << "Adding cluster " << name << endl;
   return fCluster[nclust-1];
}

void MyMainFrame::AddCluster()
{
   if (iclst < 5) {
      AddCluster(clusters[iclst++]);
      ShowIt();
   }
}

void MyMainFrame::RemoveCluster()
{
   if (iclst > 0) {
      DeleteCluster(clusters[--iclst]);
      ShowIt();
   }
}

void MyMainFrame::DeleteCluster(char* name)
{
   for (int i=0;i<nclust;i++) {
      if (!strcmp(name,fCluster[i]->GetName())) {
         cout << "Deleting cluster " << name << endl;
         // Do all stuff for closing windows
         // fComp->RemoveFrame(fCluster[i]);
         delete fCluster[i];
         ShowIt();
         nclust--;
         return ;
      }
   }
   cout << "DeleteCluster " << name << " not found." << endl;
}

void MyMainFrame::SetGlobalRootVars()
{
   gROOT->SetStyle("Plain");
   gStyle->SetLabelSize(0.08,"x");
   gStyle->SetTitleFontSize(0.2);
   gStyle->SetTitleSize(0.2);
   gStyle->SetTitleH(0.12);
   gStyle->SetTitleW(0.5);
   gStyle->SetTitleX(0.25);
   gStyle->SetTitleY(1.020);
   gStyle->SetLabelSize(0.075,"y");
   gStyle->SetPadLeftMargin(0.2);
   gStyle->SetPadRightMargin(0.15);
   gStyle->SetLabelOffset(0.025,"Y");
}

void MyMainFrame::AddCompFrame()
{
   fComp = new TGVerticalFrame(fMain,1200,1000,kVerticalFrame);
   fMain->AddFrame(fComp, new TGLayoutHints(kLHintsExpandX | kLHintsExpandY));
   cout << "fComp added" << endl;
}

void MyMainFrame::AddExit()
{
   static TGTextButton *add_cluster = 0;
   if (exit) {
      fMain->RemoveFrame(exit);
      delete exit;
   }
   exit = new TGTextButton(fMain,"&Exit","gApplication->Terminate(0)");
   fMain->AddFrame(exit, new TGLayoutHints(kLHintsCenterX,5,5,3,4));
/*
   if (!add_cluster) {
      TGHorizontalFrame *h = new TGHorizontalFrame(fMain);
      add_cluster = new TGTextButton(h, "&Add Cluster");
      h->AddFrame(add_cluster, new TGLayoutHints(kLHintsCenterX,5,5,3,4));
      add_cluster->Connect("Clicked()","MyMainFrame", this, "AddCluster()");
      TGTextButton *del_cluster = new TGTextButton(h, "&Remove Cluster");
      h->AddFrame(del_cluster, new TGLayoutHints(kLHintsCenterX,5,5,3,4));
      del_cluster->Connect("Clicked()","MyMainFrame", this, "RemoveCluster()");
      fMain->AddFrame(h, new TGLayoutHints(kLHintsExpandX,5,5,5,5));
   }
*/
}

void MyMainFrame::AddInputs()
{
   fInputs = new GCluster(fComp,1200,200,"INPUTS");
   cout << "Inputs added"  << endl;
}

void MyMainFrame::ShowIt()
{
   fComp->MapSubwindows();
   fMain->SetMWMHints(kMWMDecorAll,kMWMFuncAll,kMWMInputModeless);
   // Map all subwindows of main frame
   fMain->MapSubwindows();
   // Initialize the layout algorithm
   fMain->Resize(fMain->GetDefaultSize());
   fMain->Resize(1200,200+(nclust)*200);
   // Map main frame
   fMain->MapWindow();
}

MyMainFrame::~MyMainFrame()
{
   // Clean up used widgets: frames, buttons, layouthints
   fMain->Cleanup();
   delete fMain;
}
