#ifndef _Gui_h_
#define _Gui_h_
#include "TGraph.h"
#include "TGraphErrors.h"
#include "TGFrame.h"
#include <TQObject.h>
#include <RQ_OBJECT.h>

class TGWindow;
class TGMainFrame;
class TGCheckButton;
class TRootEmbeddedCanvas;

using namespace std;
class GCluster
{
 RQ_OBJECT("GCluster")
 public:
        GCluster(TGCompositeFrame* frame,UInt_t p,UInt_t w,char* name);
        virtual ~GCluster();
        void DoDraw();  // Draw Inputs
        void CheckBox();
        void Choose();
        void SetData(double** data){this->data=data;};
        void SetNpoints(int np){npoints=np;};
        void SetName(const char* name,int pos){names[pos]=const_cast<char *> (name);}
        char* GetName(){return name;};
 private:
         enum {NITEMS=50+1};
         int npoints; // # of points to show
         int tpoints; // total number of points
         char* name;
         double** data; // graphs as arrays, including xx
         TGCompositeFrame *ftop;
         TRootEmbeddedCanvas *fC;
         TGTextButton *button;
         TGMainFrame *fCheckBox;
         TGCheckButton **binps;
         TGraphErrors* graphs[NITEMS];
         bool show[NITEMS];
         char* names[NITEMS];
};
//====================================================================
class MyMainFrame
{
RQ_OBJECT("MyMainFrame")
 public:
    MyMainFrame(const TGWindow *p,UInt_t w,UInt_t h);
    virtual ~MyMainFrame();
    int GetNumofRuns(){return numofruns;};
    void AddRunCount(){numofruns++;};
    GCluster* AddCluster(char* name);
    void DeleteCluster(char* name);
    //GCluster* AddCluster(int icl);
    void AddCluster();
    void RemoveCluster();
    void AddCompFrame();
    void AddExit();
    void AddInputs();
    void ShowIt();
    void SetNpoints(int np);
    void SetDataInps(double** data){fInputs->SetData(data);};
    void SetGlobalRootVars();
    void SetInputName(const char* name,int pos){fInputs->SetName(name,pos);}
    void DoDrawInp(){fInputs->DoDraw();};
 private:
    TGMainFrame *fMain;
    TGVerticalFrame *fComp;
    GCluster *fInputs;
    TGTextButton *exit;
    GCluster *fCluster[6];
    int nclust;
    int numofruns;
};
#endif
