// stdlib
#include <iostream>

// ROOT
#include <TFile.h>
#include <TTree.h>
#include <TRandom3.h>

// Cintex
#include <Cintex/Cintex.h>

// local
#include <Solar/DataVector.h>
#include <Event/Track.h>

using std::cout;
using std::endl;

using Solar::DataVector;
using Event::Track;

int main() {

   ROOT::Cintex::Cintex::Enable();

   TRandom3 random( 92413 );

   TTree* tree = new TTree( "__Event__Track", "__Event__Track" );

   DataVector< Track >* v = 0;
   tree->Branch( "Branch", "Solar::DataVector<Event::Track,std::allocator<Event::Track*> >", &v );

   for ( unsigned int i = 0; i < 1e5; i++ ) {
      double r1( 0 ), r2( 0 );
      random.Rannor( r1, r2 );
      v = new DataVector< Track >( 1 );
      Track* track = new Track( 1, 1000 + 100 * r1 );
      v->at( 0 ) = track;
      tree->Fill();
      delete v;
      delete track;
      v = 0;
   }

   TFile file( "test.root", "recreate" );
   tree->Write();

   return 0;
}
