// This file is part of Solar, a small framework for data processing.
// Copyright (C) 2009 Roel Aaij

// Solar is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// Solar is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef IDATAOBJECT_H
#define IDATAOBJECT_H 1

// Include files
#include <string>

/** @class Solar::IDataObject IDataObject.h
 *  Base class for all objects that can be stored in the Data Store.
 *
 *  @author Roel Aaij
 *  @date   2008-08-22
 */

class IContainer;

class IDataObject {
public:

   /**
    * Destuctor
    */
   virtual ~IDataObject() { }

   /**
    * Get the container that this event object is in.
    *
    * @return the container, 0 if this object is not in any container.
    */
   virtual IContainer* GetContainer() const = 0;

   /**
    * Set the container that this event object is in.
    *
    * @param container
    */
   virtual void SetContainer( IContainer* container ) = 0;

   /**
    * Release this object from the container it is in
    *
    */
   virtual void Release() = 0;

};

#endif // IDATAOBJECT_H
