// This file is part of Solar, a small framework for data processing.
// Copyright (C) 2009 Roel Aaij

// Solar is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// Solar is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef DATAOBJECT_H
#define DATAOBJECT_H 1

// Include files
#include <string>

namespace Solar {

class ISession;
class IContainer;

/** @class Solar::DataObject DataObject.h
 *
 *
 *  @author Roel Aaij
 *  @date   2009-05-19
 */
class DataObject {
private:

   IContainer* m_container;

public:

   DataObject();

   virtual ~DataObject( ); ///< Destructor

   virtual IContainer* GetContainer() const;

   virtual void SetContainer( IContainer* container );

   virtual void Release();

};
}
#endif // DATAOBJECT_H
