#include <iostream>
#include <iterator>

// Solar
#include <Solar/DoubleObject.h>
#include <Solar/DataVector.h>

using namespace std;
using namespace Solar;

int main()
{
   
   // Vector method tests
   {
      // Test constuctor and destructor
      // Create a 0 size vector
      cout << "Test constructor and destructor" << endl;
      DataVector< DoubleObject >* v = new DataVector< DoubleObject >;
      v->Print();
      
      // delete
      delete v;
   }

   {
      // Test resizing
      cout << "Test resizing" << endl;
      DataVector< DoubleObject > v( 30 );
      v.Print();
      cout << "Resizing < 20" << endl;
      v.resize( 15 );
      v.Print();
      cout << "Resizing < 6" << endl;
      v.resize( 4 );
      v.Print();
      cout << "resize < 10" << endl;
      v.resize( 8 );
      v.Print();
      cout << "resize > 10" << endl;
      v.resize( 20 );
      v.Print();
   }

   {
      // Test push back and pop back
      cout << "Test push_back and pop_back" << endl;
      DataVector< DoubleObject > v;
      v.Print();
      for (size_t i = 0; i < 30; ++i) {
         v.push_back( new DoubleObject( i + 1 ) );
         v.Print();
      }
   }

   {
      // Test At()
      cout << "Test At()" << endl;
      DataVector< DoubleObject > v;
      for (size_t i = 0; i < 30; ++i) {
         v.push_back( new DoubleObject( i + 1 ) );
      }
      for (size_t i = 0; i < v.size(); ++i) {
         cout << *( v.At(i) ) << endl;
      }
   }

   // Iterator tests
   {
      // Test iterator forward
      cout << "Test iterator forward" << endl;
         DataVector< DoubleObject > v( 20 );
      double i = 0.;
      for ( DataVector< DoubleObject >::iterator it = v.begin();
            it != v.end(); ++it) {
         *it = new DoubleObject( i++ );
      }
      v.Print();
   }

   {
      // Test iterator backward
      cout << "Test iterator Backward" << endl;
      DataVector< DoubleObject > v( 20 );
      double i = 0.;
      DataVector< DoubleObject >::iterator it = v.end() - 1;
      while (true) {
         *it = new DoubleObject( i++ );
         if (it == v.begin()) break;
         --it;                              
      }
      v.Print();
   }

   {
      // Test distance
      cout << "Test iterator distance" << endl;
      DataVector< DoubleObject > v( 20 );
      DataVector< DoubleObject >::iterator it1 = v.begin() + 5;
      DataVector< DoubleObject >::iterator it2 = v.end() - 5;
      cout << "Distance = " << distance( it1, it2 ) << endl;
   }

   {
      // Test erase
      cout << "Test erase" << endl;
      DataVector< DoubleObject > v;
      for (size_t i = 0; i < 20; ++i) {
         v.push_back( new DoubleObject( i + 1 ) );
      }
      DataVector< DoubleObject >::iterator it1 = v.begin() + 5;
      DataVector< DoubleObject >::iterator it2 = v.end() - 5;
      v.erase( it1, it2 );
      v.Print();
   }

   {
      // Test release
      cout << "Test release" << endl;
      DataVector< DoubleObject > v;
      for (size_t i = 0; i < 20; ++i) {
         v.push_back( new DoubleObject( i + 1 ) );
      }
      DoubleObject* doubleObject = v.at( 10 );
      DataObject* dataObject = dynamic_cast< DataObject* >( doubleObject );
      v.Release( dataObject );
      delete dataObject;
   }

   return 0;
}
