#ifndef PARTICLE_H 
#define PARTICLE_H 1

// Include files
#include <iostream>

// STL
#include <vector>

// boost
#include <boost/pool/singleton_pool.hpp>

// local
#include "TrackState.h"
#include <Solar/DataObject.h>

namespace Event {

/** @class Event::Track Track.h
 *  
 *
 *  @author Roel Aaij
 *  @date   2009-12-08
 */
class Track : public Solar::DataObject {
public: 

   Track();

   Track( int charge, double momentum );

   virtual ~Track( );

   std::vector< TrackState >& states()
   {
      return m_states;
   }

   const std::vector< TrackState >& states() const
   {
      return m_states;
   }

   void clearStates() {
      m_states.clear();
   }

   int charge() const {
      return m_charge;
   }
   
   void setCharge( int charge )
   {
      m_charge = charge;
   }

   double momentum() const{
      return m_momentum;
   }

   void setMomentum( double momentum )
   {
      m_momentum = momentum;
   }

   /// operator new
   static void* operator new( size_t size )
   {
      void* address = 0;
      if ( sizeof( Track ) == size ) {
         // std::cout << "Using overloaded new" << std::endl;
         address = boost::singleton_pool< Track, sizeof( Track ) >::malloc();
      } else {
         address = ::operator new( size );
      }
      return address;
   }
  
   /// placement operator new
   static void* operator new( size_t size, void* pObj )
   {
      return ::operator new( size, pObj );
   }
  
   /// operator delete
   static void operator delete ( void* p )
   {
      if ( boost::singleton_pool< Track, sizeof( Track )>::is_from( p ) ) {
         // std::cout << "Using overloaded delete" << std::endl;
         boost::singleton_pool< Track, sizeof( Track )>::free( p );
      } else {
         ::operator delete( p );
      }
   }
  
   /// placement operator delete
   static void operator delete( void* p, void* pObj )
   {
      ::operator delete( p, pObj );
   }

private:

   std::vector< TrackState > m_states;
   double m_momentum;
   int m_charge;

};
}
#endif // PARTICLE_H
