// This file is part of Solar, a small framework for data processing.
// Copyright (C) 2009 Roel Aaij

// Solar is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// Solar is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Include files
#include <iostream>

// Solar
#include <Solar/IContainer.h>
#include <Solar/DataObject.h>

//-----------------------------------------------------------------------------
// Implementation file for class : DataObject
//
// 2009-05-19 : Roel Aaij
//-----------------------------------------------------------------------------

using namespace std;

namespace Solar {

//_____________________________________________________________________________
DataObject::DataObject()
   : m_container( 0 )
{

}

//_____________________________________________________________________________
DataObject::~DataObject()
{
   Release();
}

//_____________________________________________________________________________
IContainer* DataObject::GetContainer() const
{
   return m_container;
}

//_____________________________________________________________________________
void DataObject::SetContainer( IContainer* container )
{
   m_container = container;
}

//_____________________________________________________________________________
void DataObject::Release()
{
   if ( m_container ) m_container->Release( this );
}
}
