#ifndef Event_H
#define Event_H

#include "TClonesArray.h"
#include "Channel.h"


class Event : public TObject 
{
 public:
     Event();
     virtual ~Event();

     UInt_t numChannels;  // number of channels, default 64 = 4*16
     Channel* operator[]( int index){
       return dynamic_cast<Channel*>( (*fChannels)[index] );
     };
     
     Channel* GetChannels( int index){
         return dynamic_cast<Channel*>( (*fChannels)[index] );
     };
     
     TClonesArray* fChannels; //[numChannels]

     ClassDef(Event, 1) // event record for ROOT I/O

 private:
     Event(const Event &);
     Event & operator=(const Event &);
     
};

#endif//~Event_H

