#ifndef AxiSymEMField_H
#define AxiSymEMField_H


#include "TObject.h"
#include "TClonesArray.h"
#include "TFile.h"
#include "TF1.h"

#include <vector>
#include <string>
#include <iostream>

class TDirectory;

////////////////////////////////////////////////////////////////////////////////

class ElectricField : public TObject
{
private:
  TF1      *fPotentialFromChargedRing;//!

  Int_t    int1;
  Int_t    int2;

public:
  ElectricField();
  virtual ~ElectricField();

  void PrintFunction() { std::cout<<fPotentialFromChargedRing<<std::endl;
                         fPotentialFromChargedRing->Print();}

  Int_t   GetInt1() { return int1; }
  Int_t   GetInt2() { return int2; }

  void    SetInt1(Int_t i) { int1=i;}
  void    SetInt2(Int_t i) { int2=i;}

  ClassDef(ElectricField,1)
};

////////////////////////////////////////////////////////////////////////////////

class ElectroMagneticField
{
public:
  ElectroMagneticField();
  ~ElectroMagneticField();

  Bool_t E_ComponentsAreSameAsFile();

  void WriteEGeometry();

  void Initialize();

  void PrintFunction() {electricField->PrintFunction();}

  void SetInts(Int_t i,Int_t j) {electricField->SetInt1(i);
                                 electricField->SetInt2(j);}

private:

  ElectricField  *electricField;
  TFile* file;

};

#endif
