#include "TFile.h"
#include <iostream>
#include <fstream>
#include <math.h>
#include <vector>
#include <string>

#include "AxiSymEMField.hh"

ClassImp(ElectricField)

//_____________________________________________________________________________

double PotentialFromChargedRing(double *p,double *par)
{
  return par[0];
}

//_____________________________________________________________________________

ElectricField::ElectricField()
{
  fPotentialFromChargedRing = new TF1("fPotentialFromChargedRing",
				      PotentialFromChargedRing,0,1,7);
}

//_____________________________________________________________________________

ElectricField::~ElectricField()
{
  delete fPotentialFromChargedRing;  
}

//_____________________________________________________________________________

ElectroMagneticField::ElectroMagneticField()
{
  electricField = new ElectricField();
}

//_____________________________________________________________________________

ElectroMagneticField::~ElectroMagneticField()
{
  if (file)
    delete file;

  delete electricField;
}

//_____________________________________________________________________________

Bool_t ElectroMagneticField::E_ComponentsAreSameAsFile()
{
  std::cout<<"before the file is accessed: "<<std::endl;
  PrintFunction();

  ElectricField *ef = (ElectricField*)file->Get("e");

  std::cout<<"after the file is accessed: "<<std::endl;
  PrintFunction();

  ElectricField *e  =  electricField;

  if (!ef)
    return false;

  if (ef->GetInt1() != e->GetInt1() ||
      ef->GetInt2() != e->GetInt2())
    return false;

  return true;
}

//_____________________________________________________________________________

void ElectroMagneticField::WriteEGeometry()
{
  ElectricField *e = electricField;
  e->Write("e",TObject::kOverwrite);
}

//_____________________________________________________________________________

void ElectroMagneticField::Initialize()
{
  file = new TFile("field.root","UPDATE");

  if (E_ComponentsAreSameAsFile())
  {
    std::cout<<"they are the same"<<std::endl;
  }
  else
  {
    WriteEGeometry();
  }
  file->Save();
  file->Close();
  file = 0;

  return;
}
