// This never hurts! (info glibc - Node: Feature Test Macros)
#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

// dynamic library functions (dlopen, dlsym, dlerror, dlclose)
#include <dlfcn.h>

#include <stdio.h>
#include <errno.h>

int
main (int argc, char **argv)
{
    void *mylib;
    const char *mylib_name = NULL;
    char *error;
    // parse on-line arguments
    switch (argc) {
    case 2:
        mylib_name = argv[1];
        break;
    default:
	fprintf (stderr, "Usage: %s <library>\n",
		 program_invocation_short_name);
        return 0;
    }
    // try to open the shared library
    printf ("main: trying dlopen ...\n");
    dlerror();
    mylib = dlopen (mylib_name, RTLD_NOW);
    error = dlerror();
    if (error) {
        printf ("dlopen: %s\n" , error);
	return 1;
    } else {
        printf ("dlopen: : Success\n");
    }
    // close the shared library
    printf ("main: trying dlclose ...\n");
    dlerror();
    dlclose (mylib);
    error = dlerror();
    if (error) {
        printf ("dlclose: %s\n" , error);
	return (1);
    } else {
        printf ("dlclose: Success\n");
    }
    // exit successfully
    printf ("main: going to return ...\n");
    return 0;
}
