
/*
 *   File:      mydrawtools.hpp
 *   Purpose:   My draw tools and routines
 *   Author:    Jiri Kvita 
 *   Created:   Aug 28 2004
 *   Modified:  $Id: mydrawtools.hpp,v 1.3 2004/09/15 20:52:37 kvita Exp $
 */

#ifndef mydrawtools_hpp
#define mydrawtools_hpp

#include <TH1F.h>
#include <TH2F.h>
#include <TProfile.h>
#include <TGraphErrors.h>
#include <TCanvas.h>

// ________________________________________________________________________

/*
class myTCanvas: public TCanvas
{
 private:
  int fdivx, fdivy;
  bool fDrawMe;
 public:
  bool DrawMe();
  int DivideMe();
  TMyCanvas(const char* name, const char* title, Int_t wtopx, Int_t wtopy, Int_t ww, Int_t wh, bool DrawMe, int divx, int divy);
};
*/

// ________________________________________________________________________
// ________________________________________________________________________
// ________________________________________________________________________

class TMyCanvasAttributes
{
 private:
  int fdivx, fdivy;
  bool fDrawMe;
  char* fname;
 public:
  bool GetDrawMe();
  int GetDivisionX();
  int GetDivisionY();
  char* GetName();
  TMyCanvasAttributes(const char* name, bool DrawMe, int divx, int divy);
};

// ________________________________________________________________________
// ________________________________________________________________________
// ________________________________________________________________________

void SetDataStyle(TH1F *h);
// ________________________________________________________________________

void SetMCStyle(TH1F *h);
// ________________________________________________________________________

void  SetHistoStyle(TH1F* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle);
void  SetHistoStyle(TH1F* histo,char* xtitle, char* ytitle);
void  SetHistoStyle(TH1F* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle,float ymin,float ymax);
void  SetHistoStyle(TProfile* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle);
void  SetHistoStyle(TProfile* histo,char* xtitle, char* ytitle);
void  SetHistoStyle(TProfile* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle,float ymin,float ymax);
void  SetHistoStyle(TH2F* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle);
void  SetHistoStyle(TH2F* histo,char* xtitle, char* ytitle);
// ----------------------------------------------------------------
void SetGraphStyle(TGraphErrors* graph,int col,int marker,float markerSize,char* xtitle, char* ytitle);
void SetGraphStyle(TGraphErrors* graph,char* xtitle, char* ytitle);
// ________________________________________________________________________
// ________________________________________________________________________

#endif
