/*
 *   File:      histos.hpp
 *   Purpose:   histogram creating and CAL layers definitions, header file for histos.cpp
 *   Author:    Jiri Kvita
 *   Created:   27 Aug 2004 
 *   Version:   $Id: histosR.hpp,v 1.7 2004/10/02 02:06:08 kvita Exp $
 *   Changes:   Now only historical, all code moved to cpp, I don't like .o anymore, just include ... 20.9.2004
 */

#include "mytools.h"

#ifndef Responsehistos_hpp
#define Responsehistos_hpp

char ResponseDir[100];
char ResponseSoftDir[100];

const Bool_t perform2ndJetStudy=true;
char CalPart[4][10];

//Cryostat factors:

//t42:
const Float_t FCryoData_t42[2]         = {0.9583, 0.9302}; // North, South
const Float_t FCryoDataError_t42[2]    = {0.0087, 0.0082};
const Float_t FCryoMC_t42[2]           = {0.9511, 0.9511}; // N,S - both the same!
const Float_t FCryoMCError_t42[2]      = {0.0194, 0.0194};

//no t42:
const Float_t FCryoData_NoT42[2]       = {0.9638, 0.9316};// North, South
const Float_t FCryoDataError_NoT42[2]  = {0.0068, 0.0064};
const Float_t FCryoMC_NoT42[2]         = {0.9559, 0.9559};// N,S - both the same!
const Float_t FCryoMCError_NoT42[2]    = {0.0032, 0.0032};


//E' log bins:
const Int_t LnEprimebins=13;
const Float_t minLnEprime=15.,maxLnEprime=530.;
const Double_t Eprimebins[LnEprimebins+1] = {15.,20.,27.,36.,49.,60.,75.,100.,130.,165.,215.,290.,390.,530};

const Float_t ECEprimecutLow=100;
const Float_t CCEprimecutUp=2000;
const Float_t CCEprimecutLow=20;

const Float_t Zpole=91.2;
const Float_t infty=9e30;

const Float_t Rmass=10;//mass window for accepting event as Z
const Float_t ZvertexCut=50;//cm, cut on PV position

const Float_t MaxObjPt=100, MinObjPt=15.;
const Float_t EMPt_mincut=15;
//const Float_t EMPt_maxcut=100;  //should be same as maxpt in histos.hpp!!!
const Float_t EMPtcut1=15;
const Float_t EMPtcut2=15; //for Z electrons
const Float_t JetRawPtcut=10;
//const Float_t ZPtCut=30.;
//const Float_t PhiCut=2.95;
const Float_t PhiCut=2.85;

const Int_t  binseta=50, binsetadense=50, binspt=17, binsEprime=15, binsEprimeDense=105,binsRjet=600, binsphi=64, binsmet=100;
const Float_t mineta=-2.5, maxeta=2.5, minpt=0, maxpt=100, minEprime=0, maxEprime=210, minRjet=-0.5, maxRjet=2.5;
const Float_t minphi=0   , maxphi=2*Pi,minmet=0, maxmet=100;
const Int_t binsetahisto=50;

const Float_t maxcelle=20;
const Int_t binscelle=100,minieta=-45,maxieta=45,binsieta=maxieta-minieta,miniphi=0,maxiphi=65,binsiphi=maxiphi-miniphi;

// ..................... names: ......................

char 
//CC, NEC, SEC, all:
  RjetVsEprime_name[4][200],
  RjetVsEprimeProf_name[4][200],

  RjetVsJetDetEta_name[200],
  RjetVsJetDetEtaProf_name[200],

  EdetVsEprimeProf_name[4][200],
  EdetVsEprime_name[4][200],
  NormEdiffVsEprime_name[4][200],
  NormEdiffVsEprimeProf_name[4][200],

//CC, NEC, SEC
  RjetVsEprime_2ndJetRawPt30_name[3][200],
  RjetVsEprime_2ndJetRawPt30Prof_name[3][200],
  RjetVsEprime_2ndJetRawPt20_name[3][200],
  RjetVsEprime_2ndJetRawPt20Prof_name[3][200],
  RjetVsEprime_2ndJetRawPt15_name[3][200],
  RjetVsEprime_2ndJetRawPt15Prof_name[3][200],
  RjetVsEprime_2ndJetRawPt10_name[3][200],
  RjetVsEprime_2ndJetRawPt10Prof_name[3][200],

 
  EprimeVsJetRawPtCuts_name[200],
  ObjJetPhiDiff_name[200],

// ..................... labels: ......................

  RjetVsEprime_label[4][200],
  RjetVsEprimeProf_label[4][200],

  RjetVsJetDetEta_label[200],
  RjetVsJetDetEtaProf_label[200],

  EdetVsEprimeProf_label[4][200],
  EdetVsEprime_label[4][200],
  NormEdiffVsEprime_label[4][200],
  NormEdiffVsEprimeProf_label[4][200],

//CC, NEC, SEC
  RjetVsEprime_2ndJetRawPt30_label[3][200],
  RjetVsEprime_2ndJetRawPt30Prof_label[3][200],
  RjetVsEprime_2ndJetRawPt20_label[3][200],
  RjetVsEprime_2ndJetRawPt20Prof_label[3][200],
  RjetVsEprime_2ndJetRawPt15_label[3][200],
  RjetVsEprime_2ndJetRawPt15Prof_label[3][200],
  RjetVsEprime_2ndJetRawPt10_label[3][200],
  RjetVsEprime_2ndJetRawPt10Prof_label[3][200],

  EprimeVsJetRawPtCuts_label[200],
  ObjJetPhiDiff_label[200];

Int_t GenerateHistogramNames(char* analysis);
Int_t CreateMyHistograms(THisto** histoarray,Int_t nhistos,char* analysis,char* option);

Bool_t isJetCC(Float_t jetdeteta);
Bool_t isJetNEC(Float_t jetdeteta);//North EC
Bool_t isJetSEC(Float_t jetdeteta);//South EC
Int_t GetCalPartID(Float_t jetdeteta);

Bool_t WellContainedEM(Float_t EMeta);

#endif
