/*
 *   File:      histos.cpp
 *   Purpose:   histogram creating for Response study
 *   Author:    Jiri Kvita
 *   Created:   26 Aug 2004 
 *   Version:   $Id: histosR.cpp,v 1.7 2004/10/02 02:06:08 kvita Exp $
 *   Changes:   now all code here, copied all header to cpp to make it work
                only as an include nstead of linking .o 
 */

#include "mytools.h"
//#include "histosR.hpp"


char ResponseDir[100];
char ResponseSoftDir[100];

const Bool_t perform2ndJetStudy=true;
char CalPart[4][10];

//Cryostat factors, taken from Sasa's photon+jet

//t42:
const Float_t FCryoData_t42[2]         = {0.9583, 0.9302}; // North, South
const Float_t FCryoDataError_t42[2]    = {0.0087, 0.0082};
const Float_t FCryoMC_t42[2]           = {0.9511, 0.9511}; // N,S - both the same!
const Float_t FCryoMCError_t42[2]      = {0.0194, 0.0194};

//no t42:
const Float_t FCryoData_NoT42[2]       = {0.9638, 0.9316};// North, South
const Float_t FCryoDataError_NoT42[2]  = {0.0068, 0.0064};
const Float_t FCryoMC_NoT42[2]         = {0.9559, 0.9559};// N,S - both the same!
const Float_t FCryoMCError_NoT42[2]    = {0.0032, 0.0032};


//E' log bins:

//const Int_t LnEprimebins=13;
const Float_t minLnEprime=15.,maxLnEprime=530.;
//original:const Double_t Eprimebins[LnEprimebins+1] = {15.,20.,27.,36.,49.,60.,75.,100.,130.,165.,215.,290.,390.,530};

//const Int_t LnEprimebins=6;
//const Double_t Eprimebins[LnEprimebins+1] = {15.,50.,100.,165.,290.,390.,530};

const Int_t LnEprimebins=8;
const Double_t Eprimebins[LnEprimebins+1] = {15.,30.,60.,100.,140.,200.,300.,400.,530};

const Float_t ECEprimecutLow=100;
const Float_t CCEprimecutUp=2000;
const Float_t CCEprimecutLow=20;

const Float_t Zpole=91.2;
const Float_t infty=9e30;

const Float_t Rmass=10;//mass window for accepting event as Z
const Float_t ZvertexCut=50;//cm, cut on PV position

const Float_t MaxObjPt=100, MinObjPt=15.;
const Float_t EMPt_mincut=15;
//const Float_t EMPt_maxcut=100;  //should be same as maxpt in histos.hpp!!!
const Float_t EMPtcut1=15;
const Float_t EMPtcut2=15; //for Z electrons
const Float_t JetRawPtcut=10;
//const Float_t ZPtCut=30.;

//const Float_t PhiCut=2.85;
const Float_t PhiCut=2.7;

const Int_t  binseta=50, binsetadense=50, binspt=17, binsEprime=15, binsEprimeDense=105,binsRjet=600, binsphi=64, binsmet=100;
const Float_t mineta=-2.5, maxeta=2.5, minpt=0, maxpt=100, minEprime=0, maxEprime=210, minRjet=-0.5, maxRjet=2.5;
const Float_t minphi=0   , maxphi=2*Pi,minmet=0, maxmet=100;
const Int_t binsetahisto=50;

const Float_t maxcelle=20;
const Int_t binscelle=100,minieta=-45,maxieta=45,binsieta=maxieta-minieta,miniphi=0,maxiphi=65,binsiphi=maxiphi-miniphi;

const int maxcharlen=200;

// ..................... names: ......................

char 
//CC, NEC, SEC, all:
  RjetVsEprime_name[4][maxcharlen],
  RjetVsEprimeProf_name[4][maxcharlen],

  RjetVsJetDetEta_name[maxcharlen],
  RjetVsJetDetEtaProf_name[maxcharlen],

  EdetVsEprimeProf_name[4][maxcharlen],
  EdetVsEprime_name[4][maxcharlen],
  NormEdiffVsEprime_name[4][maxcharlen],
  NormEdiffVsEprimeProf_name[4][maxcharlen],

//CC, NEC, SEC
  RjetVsEprime_2ndJetRawPt30_name[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt30Prof_name[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt20_name[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt20Prof_name[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt15_name[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt15Prof_name[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt10_name[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt10Prof_name[3][maxcharlen],

 
  EprimeVsJetRawPtCuts_name[maxcharlen],
  ObjJetPhiDiff_name[maxcharlen],

// ..................... labels: ......................

  RjetVsEprime_label[4][maxcharlen],
  RjetVsEprimeProf_label[4][maxcharlen],

  RjetVsJetDetEta_label[maxcharlen],
  RjetVsJetDetEtaProf_label[maxcharlen],

  EdetVsEprimeProf_label[4][maxcharlen],
  EdetVsEprime_label[4][maxcharlen],
  NormEdiffVsEprime_label[4][maxcharlen],
  NormEdiffVsEprimeProf_label[4][maxcharlen],

//CC, NEC, SEC
  RjetVsEprime_2ndJetRawPt30_label[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt30Prof_label[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt20_label[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt20Prof_label[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt15_label[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt15Prof_label[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt10_label[3][maxcharlen],
  RjetVsEprime_2ndJetRawPt10Prof_label[3][maxcharlen],

  EprimeVsJetRawPtCuts_label[maxcharlen],
  ObjJetPhiDiff_label[maxcharlen];


Int_t GenerateHistogramNames(char* analysis)
{
  strcpy(CalPart[0],"CC");
  strcpy(CalPart[1],"NEC");
  strcpy(CalPart[2],"SEC");
  strcpy(CalPart[3],"All");

  strcpy(ResponseDir,"Response/");
  strcpy(ResponseSoftDir,"ResponseSoft/");
 

  // ***histograms
  // ***names
  //important:
  
  //              --- Rjet ---
  //Eprime:
  for (Int_t c=0;c<4;++c) {
    strcpy(RjetVsEprime_name[c],CalPart[c]);
    strcat(RjetVsEprime_name[c],"RjetVsEprime");
    strcpy(RjetVsEprimeProf_name[c],CalPart[c]);
    strcat(RjetVsEprimeProf_name[c],"RjetVsEprimeProf");

    strcpy(EdetVsEprimeProf_name[c],CalPart[c]);
    strcat(EdetVsEprimeProf_name[c],"EdetVsEprimeProf");
    strcpy(EdetVsEprime_name[c],CalPart[c]);
    strcat(EdetVsEprime_name[c],"EdetVsEprime");

    strcpy(NormEdiffVsEprime_name[c],CalPart[c]);
    strcat(NormEdiffVsEprime_name[c],"NormEdiffVsEprime");
    strcpy(NormEdiffVsEprimeProf_name[c],CalPart[c]);
    strcat(NormEdiffVsEprimeProf_name[c],"NormEdiffVsEprimeProf");

  }
  //JetDetEta:
  strcpy(RjetVsJetDetEta_name,"RjetVsJetDetEta");
  strcpy(RjetVsJetDetEtaProf_name,"RjetVsJetDetEtaProf");
 
  if (perform2ndJetStudy) {
    //different pt cuts allowed for the presence of the second jet:
    for(Int_t c=0;c<3;++c) {
      // -- 30 --
      strcpy(RjetVsEprime_2ndJetRawPt30_name[c],CalPart[c]);
      strcat(RjetVsEprime_2ndJetRawPt30_name[c],"RjetVsEprime_2ndJetRawPt30");
      strcpy(RjetVsEprime_2ndJetRawPt30Prof_name[c],CalPart[c]);      
      strcat(RjetVsEprime_2ndJetRawPt30Prof_name[c],"RjetVsEprime_2ndJetRawPt30Prof");  
      // -- 20 --
      strcpy(RjetVsEprime_2ndJetRawPt20_name[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt20_name[c],"RjetVsEprime_2ndJetRawPt20");
      strcpy(RjetVsEprime_2ndJetRawPt20Prof_name[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt20Prof_name[c],"RjetVsEprime_2ndJetRawPt20Prof");  
      // -- 15 --
      strcpy(RjetVsEprime_2ndJetRawPt15_name[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt15_name[c],"RjetVsEprime_2ndJetRawPt15");
      strcpy(RjetVsEprime_2ndJetRawPt15Prof_name[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt15Prof_name[c],"RjetVsEprime_2ndJetRawPt15Prof");  
      // -- 10 --
      strcpy(RjetVsEprime_2ndJetRawPt10_name[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt10_name[c],"RjetVsEprime_2ndJetRawPt10");
      strcpy(RjetVsEprime_2ndJetRawPt10Prof_name[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt10Prof_name[c],"RjetVsEprime_2ndJetRawPt10Prof");  
    }//CAL parts loop
  }
    
  //other:
  //strcpy(EprimeVsJetRawPtCuts_name,analysis);   
  strcpy(EprimeVsJetRawPtCuts_name,"EprimeVsJetRawPtCuts");
  strcpy(ObjJetPhiDiff_name,analysis);      strcat(ObjJetPhiDiff_name,"JetPhiDiff");

  
  // ***labels
  //important:
  
  //Rjet
  for (Int_t c=0;c<4;++c) {
    strcpy(RjetVsEprime_label[c],CalPart[c]);
    strcat(RjetVsEprime_label[c],"R_{jet} vs. E'");
    strcpy(RjetVsEprimeProf_label[c],CalPart[c]);
    strcat(RjetVsEprimeProf_label[c],"R_{jet} vs. E', Profile");

    strcpy(EdetVsEprimeProf_label[c],CalPart[c]);
    strcat(EdetVsEprimeProf_label[c],"E_{det} vs. E', Profile");
    strcpy(EdetVsEprime_label[c],CalPart[c]);
    strcat(EdetVsEprime_label[c],"E_{det} vs. E'");

    strcpy(NormEdiffVsEprime_label[c],CalPart[c]);
    strcat(NormEdiffVsEprime_label[c],"(E'-E_{det})/E'");
    strcpy(NormEdiffVsEprimeProf_label[c],CalPart[c]);
    strcat(NormEdiffVsEprimeProf_label[c],"(E'-E_{det})/E, profile");
  }
  strcat(RjetVsJetDetEta_label,"Rjet vs. #eta_{jet}^{det}");
  strcat(RjetVsJetDetEtaProf_label,"Rjet vs. #eta_{jet}^{det}, Profile");
  

  if (perform2ndJetStudy) {
    for(Int_t c=0;c<3;++c) {
      //different pt cuts allowed for the presence of the second jet:
      // -- 30 --
      strcpy(RjetVsEprime_2ndJetRawPt30_label[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt30_label[c],"R_{jet} vs. E', 2nd Jet raw p_{T}<30");
      strcpy(RjetVsEprime_2ndJetRawPt30Prof_label[c],CalPart[c]);   
      strcat(RjetVsEprime_2ndJetRawPt30Prof_label[c],"R_{jet} vs. E', 2nd Jet raw p_{T}<30, Profile");  
      
      // -- 20 --
      strcpy(RjetVsEprime_2ndJetRawPt20_label[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt20_label[c],"R_{jet} vs. E', 2nd Jet raw p_{T}<20");
      strcpy(RjetVsEprime_2ndJetRawPt20Prof_label[c],CalPart[c]);   
      strcat(RjetVsEprime_2ndJetRawPt20Prof_label[c],"R_{jet} vs. E', 2nd Jet raw p_{T}<20, Profile");  
      
      // -- 15 --
      strcpy(RjetVsEprime_2ndJetRawPt15_label[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt15_label[c],"R_{jet} vs. E', 2nd Jet raw p_{T}<15");
      strcpy(RjetVsEprime_2ndJetRawPt15Prof_label[c],CalPart[c]);   
      strcat(RjetVsEprime_2ndJetRawPt15Prof_label[c],"R_{jet} vs. E', 2nd Jet raw p_{T}<15, Profile");  
      
      // -- 10 --
      strcpy(RjetVsEprime_2ndJetRawPt10_label[c],CalPart[c]);       
      strcat(RjetVsEprime_2ndJetRawPt10_label[c],"R_{jet} vs. E', 2nd Jet raw p_{T}<10");
      strcpy(RjetVsEprime_2ndJetRawPt10Prof_label[c],CalPart[c]);   
      strcat(RjetVsEprime_2ndJetRawPt10Prof_label[c],"R_{jet} vs. E', 2nd Jet raw p_{T}<10, Profile");  
    }//CAL parts loop
  }
  
  //other
  //strcpy(EprimeVsJetRawPtCuts_label,analysis);   
  strcpy(EprimeVsJetRawPtCuts_label,"E' versus p^{jet}_{T}");
  //strcpy(RjetVsJetDetEta_label,analysis);   
  
  //strcpy(ObjJetPhiDiff_label,analysis);      
  strcpy(ObjJetPhiDiff_label," - Jet #Delta#phi");
}

// -----------------------------------------------------------------------

Int_t CreateMyHistograms(THisto** histoarray,Int_t nhistos,char* analysis,char* option)
{
  THisto* Histo        = histoarray[0];
  THisto* JESHisto     = histoarray[1];
  THisto* METHisto     = histoarray[4];
  THisto* EMHisto      = histoarray[5];
  THisto* JetHisto     = histoarray[6];
  THisto* ObjHisto     = histoarray[7];
  THisto* ResponseHisto = histoarray[8];
  THisto* ResponseSoftHisto = histoarray[9];

  GenerateHistogramNames(analysis);

  //........................................................................  
  //jet histograms:
  if (JetHisto) {
    JetHisto->AddH1("JetPhi","Jet physical #phi",binsphi*2,0,maxphi);
    JetHisto->AddH1("JetDetPhi","Jet detector #phi",binsphi*2,0,maxphi);
    JetHisto->AddH2("JetDetEtaDetPhiNoCuts","Jet #eta_{det}#times#phi_{det} plot, No Cuts",binsetadense,mineta,maxeta,binsphi,minphi,maxphi);
    //........................................................................  
    JetHisto->AddH1("JetDetEta","Jet detector #eta",binseta,mineta,maxeta,option);
    JetHisto->AddH1("JetEta","Jet detector #eta",binseta,mineta,maxeta,option);
    JetHisto->AddH1("JetRawPtNoCuts","p_{T}^{jet}, no cuts",100,0,maxpt,option);
    JetHisto->AddH1("JetRawPtCuts","p_{T}^{jet}, cuts",100,0,maxpt,option);
    JetHisto->AddH1("JetRawPtSubleadingCuts","Subleading Jet p_{T}, cuts",100,0,maxpt,option);
    JetHisto->AddH2("JetRawPtCutsLeadingVsSubleading","Leading vs. Subleading jet p_{T}, cuts",100,0,maxpt,100,0,maxpt,option);
    
    JetHisto->AddH1("JetDistanceLeadingSubleading","#DeltaR jet leading-subleading",4*binsphi,0,5.5);
    JetHisto->AddH1("JetPhiDiffLeadingSubleading","#Delta#phi jet leading-subleading",4*binsphi,-2*maxphi,2*maxphi);
    JetHisto->AddH2("JetPhiLeadingVsSubleading","#Delta#phi jet leading vs. subleading",binsphi,minphi,maxphi,binsphi,minphi,maxphi);
  }    


  if (ResponseHisto) {
    if (!(strcmp(analysis,"Z"))) {
   
      // important:
      //Rjet
      for(Int_t c=0;c<4;++c) {
	ResponseHisto->AddH2((char*)RjetVsEprime_name[c],(char*)RjetVsEprime_label[c],
			     LnEprimebins,(Double_t*)Eprimebins,binsRjet,minRjet,maxRjet,option);
	ResponseHisto->AddProfile((char*)RjetVsEprimeProf_name[c],(char*)RjetVsEprimeProf_label[c],
				  LnEprimebins,(Double_t*)Eprimebins,minRjet,maxRjet);
      }
      ResponseHisto->AddH2((char*)RjetVsJetDetEta_name,(char*)RjetVsJetDetEta_label,binseta,mineta,maxeta,binsRjet,minRjet,maxRjet,option);
      ResponseHisto->AddProfile((char*)RjetVsJetDetEtaProf_name,(char*)RjetVsJetDetEtaProf_label,binseta,mineta,maxeta,minRjet,maxRjet);

      //E' vs. Edet of the jet!
      //ResponseHisto->AddH2("EdetVsEprime","E_{det} vs. E'",binsEprimeDense,minEprime,maxEprime,binsEprimeDense,minEprime,maxEprime);
     
      //ResponseHisto->AddProfile("EdetVsEprimeProf","E_{det} vs. E', profile",LnEprimebins,(Double_t*)Eprimebins,minLnEprime,maxLnEprime);

      for(Int_t c=0;c<4;++c) {
	ResponseHisto->AddH2((char*)EdetVsEprime_name[c],(char*)EdetVsEprime_label[c],
			     LnEprimebins,(Double_t*)Eprimebins,binsEprimeDense,minLnEprime,maxLnEprime);
	//                  binsEprimeDense,minEprime,maxEprime,binsEprimeDense,minEprime,maxEprime);
	ResponseHisto->AddProfile((char*)EdetVsEprimeProf_name[c],(char*)EdetVsEprimeProf_label[c],
				  LnEprimebins,(Double_t*)Eprimebins,minLnEprime,maxLnEprime);

	//TH2(const char* name, const char* title, Int_t nbinsx, const Double_t* xbins, Int_t nbinsy, Axis_t ylow, Axis_t yup);!!!
  
	ResponseHisto->AddH2((char*)NormEdiffVsEprime_name[c],(char*)NormEdiffVsEprime_label[c],
			     LnEprimebins,(Double_t*)Eprimebins,binsEprimeDense,0,1);
			     //			     binsEprimeDense,minEprime,maxEprime,binsEprimeDense,0,1);
	ResponseHisto->AddProfile((char*)NormEdiffVsEprimeProf_name[c],(char*)NormEdiffVsEprimeProf_label[c],
				  LnEprimebins,(Double_t*)Eprimebins,0,1);
      }
      //ResponseHisto->AddProfile("EdetVsEprimeProf","E_{det} vs. E', profile",binsEprimeDense,minEprime,maxEprime,minEprime,maxEprime);

      ResponseHisto->AddH2("EprimeVsEjetJES","E' vs. E_{jet} JES corr.",LnEprimebins,(Double_t*)Eprimebins,LnEprimebins,(Double_t*)Eprimebins);
      ResponseHisto->AddH1("Rjet","R_{jet}",binsRjet,minRjet,maxRjet,option);
      ResponseHisto->AddH1("Eprime","E'",binsEprime,minEprime, maxEprime,option);
      ResponseHisto->AddH2("EprimeGoodVsBad","E' good vs bad",LnEprimebins,(Double_t*)Eprimebins,LnEprimebins,(Double_t*)Eprimebins,option);


      //less important
      ResponseHisto->AddH2((char*)EprimeVsJetRawPtCuts_name,(char*)EprimeVsJetRawPtCuts_label,binspt,0,JetRawPtcut,binsEprime,minEprime, maxEprime,option);
      ResponseHisto->AddH1((char*)ObjJetPhiDiff_name,(char*)ObjJetPhiDiff_label,4*binsphi,-2*maxphi,2*maxphi);
      
 if (perform2ndJetStudy) {
   //2nd jet in the event:
   // -- 30 --
   ResponseSoftHisto->AddH2("RjetVsJetDetEta_2ndJetRawPt30","R_{jet} vs. #eta^{jet}_{det} , 2nd Jet raw p_{T}<30",binseta,mineta,maxeta,binsRjet,minRjet,maxRjet,option);
   ResponseSoftHisto->AddProfile("RjetVsJetDetEta_2ndJetRawPt30Prof","R_{jet} vs. #eta^{jet}_{det} , 2nd Jet raw p_{T}<30, Profile",binseta,mineta,maxeta,minRjet,maxRjet);
   // -- 20 --
   ResponseSoftHisto->AddH2("RjetVsJetDetEta_2ndJetRawPt20","R_{jet} vs. #eta^{jet}_{det} , 2nd Jet raw p_{T}<20",binseta,mineta,maxeta,binsRjet,minRjet,maxRjet,option);
   ResponseSoftHisto->AddProfile("RjetVsJetDetEta_2ndJetRawPt20Prof","R_{jet} vs. #eta^{jet}_{det} , 2nd Jet raw p_{T}<20, Profile",binseta,mineta,maxeta,minRjet,maxRjet);
   // -- 15 --
   ResponseSoftHisto->AddH2("RjetVsJetDetEta_2ndJetRawPt15","R_{jet} vs. #eta^{jet}_{det} , 2nd Jet raw p_{T}<15",binseta,mineta,maxeta,binsRjet,minRjet,maxRjet,option);
   ResponseSoftHisto->AddProfile("RjetVsJetDetEta_2ndJetRawPt15Prof","R_{jet} vs. #eta^{jet}_{det} , 2nd Jet raw p_{T}<15, Profile",binseta,mineta,maxeta,minRjet,maxRjet);
   // -- 10 --
   ResponseSoftHisto->AddH2("RjetVsJetDetEta_2ndJetRawPt10","R_{jet} vs. #eta^{jet}_{det} , 2nd Jet raw p_{T}<10",binseta,mineta,maxeta,binsRjet,minRjet,maxRjet,option);
   ResponseSoftHisto->AddProfile("RjetVsJetDetEta_2ndJetRawPt10Prof","R_{jet} vs. #eta^{jet}_{det} , 2nd Jet raw p_{T}<10, Profile",binseta,mineta,maxeta,minRjet,maxRjet);
   
 }
 
 //2nd jet allowed:
 // -- 30 --
 for (Int_t c=0;c<3;++c) {
   ResponseSoftHisto->AddH2((char*)RjetVsEprime_2ndJetRawPt30_name[c],(char*)RjetVsEprime_2ndJetRawPt30_label[c],LnEprimebins,(Double_t*)Eprimebins,binsRjet,minRjet,maxRjet,option);
   ResponseSoftHisto->AddProfile((char*)RjetVsEprime_2ndJetRawPt30Prof_name[c],(char*)RjetVsEprime_2ndJetRawPt30Prof_label[c],LnEprimebins,(Double_t*)Eprimebins,minRjet,maxRjet);
   // -- 20 --
   ResponseSoftHisto->AddH2((char*)RjetVsEprime_2ndJetRawPt20_name[c],(char*)RjetVsEprime_2ndJetRawPt20_label[c],LnEprimebins,(Double_t*)Eprimebins,binsRjet,minRjet,maxRjet,option);
   ResponseSoftHisto->AddProfile((char*)RjetVsEprime_2ndJetRawPt20Prof_name[c],(char*)RjetVsEprime_2ndJetRawPt20Prof_label[c],LnEprimebins,(Double_t*)Eprimebins,minRjet,maxRjet);
   // -- 15 --
   ResponseSoftHisto->AddH2((char*)RjetVsEprime_2ndJetRawPt15_name[c],(char*)RjetVsEprime_2ndJetRawPt15_label[c],LnEprimebins,(Double_t*)Eprimebins,binsRjet,minRjet,maxRjet,option);
   ResponseSoftHisto->AddProfile((char*)RjetVsEprime_2ndJetRawPt15Prof_name[c],(char*)RjetVsEprime_2ndJetRawPt15Prof_label[c],LnEprimebins,(Double_t*)Eprimebins,minRjet,maxRjet);
   // -- 10 --
   ResponseSoftHisto->AddH2((char*)RjetVsEprime_2ndJetRawPt10_name[c],(char*)RjetVsEprime_2ndJetRawPt10_label[c],LnEprimebins,(Double_t*)Eprimebins,binsRjet,minRjet,maxRjet,option);
   ResponseSoftHisto->AddProfile((char*)RjetVsEprime_2ndJetRawPt10Prof_name[c],(char*)RjetVsEprime_2ndJetRawPt10Prof_label[c],LnEprimebins,(Double_t*)Eprimebins,minRjet,maxRjet);
 }//CAL parts loop

    }// 2nd jet allowed
     

    }//if ResponseHisto
    

  if (EMHisto) {
      EMHisto->AddH1("EMsPhiDiff","EMs #phi difference (leading-subleading)",binsphi*4,-2*maxphi,2*maxphi);
      EMHisto->AddH1("1EMJetPhiDiff","Leading EM - Jet #phi difference",binsphi*4,-2*maxphi,2*maxphi);
      EMHisto->AddH1("2EMJetPhiDiff","Subleading EM - Jet #phi difference",binsphi*4,-2*maxphi,2*maxphi);
      EMHisto->AddH1("EMDistanceLeadingSubleading","#DeltaR EM leading-subleading",4*binsphi,0,5.5);
      EMHisto->AddH1("JetEMDistanceBothLeading","#DeltaR Jet-EM, both leading",4*binsphi,0,5.5);
      EMHisto->AddH1("JetEMDistanceLeadingSubleading","#DeltaR leading Jet-subleading EM",4*binsphi,0,5.5);
    }
    if (ObjHisto) {
      ObjHisto->AddH1("EMsPhiDiff_Zjetbktobk","EMs #phi difference (leading-subleading), Z-jet bktobk",binsphi*4,-2*maxphi,2*maxphi);
      ObjHisto->AddH1("1EMJetPhiDiff_Zjetbktobk","Leading EM - Jet #phi difference, Z-jet bktobk",binsphi*4,-2*maxphi,2*maxphi);
      ObjHisto->AddH1("2EMJetPhiDiff_Zjetbktobk","Subleading EM - Jet #phi difference, Z-jet bktobk",binsphi*4,-2*maxphi,2*maxphi);
      //EM phi axis studies:
      ObjHisto->AddH1("ZPhiVectoraxisPhiDiff","Z - Vector EMaxis #phi difference",binsphi*4,-2*maxphi,2*maxphi);
      ObjHisto->AddH1("JetPhiVectoraxisPhiDiff","Jet - Vector EM axis #phi difference",binsphi*4,-2*maxphi,2*maxphi);
      ObjHisto->AddH1("ZPt0_100","Z p_{T} in range 0-100 GeV",100,0,100);

     
      //........................................................................  
  //histos for photon-jet study:
  //if(!strcmp(analysis,"Photon")) {
  //}
  
  //........................................................................  
  //histos for Z-jet study:
  if(!strcmp(analysis,"Z")) {
    //........................................................................  
    //Z histos: 

    ObjHisto->AddH1("ZEta","Z #eta",binseta,mineta,maxeta,option);
    ObjHisto->AddH1("ZPt","Z p_{T}",100,0,MaxObjPt,option);
    ObjHisto->AddH1("ZPhi","Z #phi",binsphi/2,minphi,maxphi);

    ObjHisto->AddH1("ZEta_1jet","Z #eta, 1 jet only",binseta,mineta,maxeta,option);
    ObjHisto->AddH1("ZPt_1jet","Z p_{T}, 1 jet only",100,0,MaxObjPt,option);
    ObjHisto->AddH1("ZPhi_1jet","Z #phi, 1 jet only",binsphi/2,minphi,maxphi);

    ObjHisto->AddH1("Zmass","Z mass",100,0,200);
    ObjHisto->AddH1("Zmass_window","Z mass window, both EMs trkmatched",100,0,200);
    ObjHisto->AddH1("Zmass_Zjetbktobk","Z mass, Z-jet bktobk",100,0,200);
    ObjHisto->AddH2("ZmassVsMET","Zmass vs. mjmet",50,0,200,50,minmet,maxmet);
    ObjHisto->AddH2("ZmassVsPt","Zmass vs. p_{T}^{Z}",50,0,200,50,MinObjPt,MaxObjPt);
    
  }

    }
  //........................................................................  
  //EM histos: 
    if (EMHisto) {
      EMHisto->AddH1("EMDetEta","EM detector #eta",binsetahisto,mineta,maxeta,option);
      EMHisto->AddH1("EMEta","EM physical #eta",binsetahisto,mineta,maxeta,option);
      EMHisto->AddH1("EMPt","EM p_{T}",100,0,maxpt,option);
      EMHisto->AddH1("EMPtCuts","EM p_{T}, cuts",100,0,maxpt,option);
      EMHisto->AddH1("EMPhi","EM #phi",binsphi*2,0,maxphi);
      EMHisto->AddH1("EMDetPhi","EM detector #phi",binsphi*2,0,maxphi);
      EMHisto->AddH2("EMDetEtaDetPhiNoCuts","EM #eta_{det}#times#phi_{det} plot, No Cuts",binsetadense,mineta,maxeta,binsphi,minphi,maxphi);   
      EMHisto->AddH2("LeadingEMPtVsSubleadingEMPt","Leading versus Subleading EM p_{T}",binspt,minpt,maxpt,binspt,minpt,maxpt);      
    }

      //........................................................................
      //general histograms:
    if (Histo) {
      Histo->AddH1("njetshisto","n_{jets}",15,0,15,option);
      Histo->AddH1("runnumgood","Good Runnumbers",150000,200000,350000,option);
      Histo->AddH1("runnumall","All Runnumbers",150000,200000,350000,option);
      Histo->AddH1("nEMshisto","Number of EM candidates",5,0,5,option);      
      Histo->AddH2("njetsvsnEMs","n_{jets} versus n_{EMs}",15,0,15,15,0,15,option);
    }
  //........................................................................
  //missing ET histograms
    if (METHisto) {
      METHisto->AddH1("mjmet","Missing E_{T} mjmet, no cuts",binsmet,minmet,maxmet,option);
      METHisto->AddH1("ejmet","Missing E_{T} mjmet, no cuts",binsmet,minmet,maxmet,option);
      METHisto->AddH1("calmet","Missing E_{T} mjmet, no cuts",binsmet,minmet,maxmet,option);
      METHisto->AddH1("ues","Unclustered Energy",100,0,100);
      METHisto->AddH1("uex","Unclustered Energy x",100,0,100);
      METHisto->AddH1("uey","Unclustered Energy y",100,0,100);
    }
  //JES correction histograms:
    if(JESHisto) {
      JESHisto->AddH1("jes0","JES Correction factor",100,0,2,option);
      JESHisto->AddH1("jes1","JES Stat error",100,0,1,option);
      JESHisto->AddH1("jes2","JES Syst error",100,0,1,option);
    }
 
  //........................................................................

}

// ----------------------------------------------------------------------
Bool_t WellContainedEM(Float_t EMeta)
{
  return ( (fabs(EMeta)<1) || ((1.6<fabs(EMeta))&&(fabs(EMeta)<2.5))  ) ;
}

// ----------------------------------------------------------------------
Bool_t isJetCC(Float_t jetdeteta)
{
  return (fabs(jetdeteta)<0.5);
}
// ----------------------------------------------------------------------
Bool_t isJetNEC(Float_t jetdeteta) //North EC
{
  return ( (jetdeteta<2.5) && (jetdeteta>1.8) );
}
// ----------------------------------------------------------------------
Bool_t isJetSEC(Float_t jetdeteta) //South EC
{
return ( (jetdeteta>-2.5) && (jetdeteta<-1.8) );
}
// ----------------------------------------------------------------------
Int_t GetCalPartID(Float_t jetdeteta)
{
  if (isJetCC(jetdeteta)) return 0;
  if (isJetNEC(jetdeteta)) return 1;
  if (isJetSEC(jetdeteta)) return 2;
  return -1;
}
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
