
#ifndef fitResponse_cpp
#define fitResponse_cpp


//The ROOT standard fitter based on TMinuit

#include <TROOT.h>
#include <TMinuit.h>
#include <TFitter.h>
#include <TGraphErrors.h>
#include <TF1.h>
//#include "mytools.h"

const double E0 = 100; // E0 in GeV
const int Npar = 5;

// altered from Sasa Kupco's original code, jiri Kvita Oct 25 2004

// ______________________________________________________________
// ______________________________________________________________
// ______________________________________________________________

//expected to get Rjet(Edet) already!

void fitMethod(double* grad, double& chi2, double* par, int flag, 
	       TGraphErrors* RjetCCgraph, TGraphErrors* RjetNECgraph, TGraphErrors* RjetSECgraph);

// ______________________________________________________________
// ______________________________________________________________
// ______________________________________________________________
  
int fitResponse( TGraphErrors* RjetCCgraph, TGraphErrors* RjetNECgraph, TGraphErrors* RjetSECgraph,
		 int flag,  double covarquad[Npar][Npar], TF1* fErrQuad)

{

  // const int Npar = 5; // p0, p1, p2, CryoNEC, CryoSEC
  Int_t tmp=Npar;
  //is 'fine':
  //TFitter* fitter = 0;
  // fails:
  TFitter* fitter = new TFitter(tmp);
  fitter->SetFCN((void*) fitMethod);
  
  // initial Rjet fit values
  double par[Npar]    = { 0.22, 0.188, 0.0, 0.932, 0.96};
  double parErr[Npar] = { 0.01, 0.01, 0.01, 0.1,   0.1};

  // seting fit parameters and their range
  fitter->SetParameter(0, "p0", par[0], parErr[0], 0, 1);
  fitter->SetParameter(1, "p1", par[1], parErr[1], -0.4, 0.4);
  fitter->SetParameter(2, "p2", par[2], parErr[2], -0.2, 0.2);
  fitter->SetParameter(3, "FcrECS", par[3], parErr[3], 0.5, 1.2);
  fitter->SetParameter(4, "FcrECN", par[4], parErr[4], 0.5, 1.2);

  // if (flag==1) fitter->FixParameter(2); // linear fit

  // perform the minimization using TFitter object, which uses TMinuit
  fitter->ExecuteCommand("MINI", 0, 0);
  fitter->ExecuteCommand("MINO", 0, 0);
  fitter->ExecuteCommand("MINO", 0, 0);

  // get fit parameters

  TMinuit* minuit = (TMinuit*) gROOT->GetListOfSpecials()->FindObject("MINUIT");

  minuit->GetParameter(0, par[0], parErr[0]);
  minuit->GetParameter(1, par[1], parErr[1]);
  minuit->GetParameter(2, par[2], parErr[2]);
  minuit->GetParameter(3, par[3], parErr[3]);
  minuit->GetParameter(4, par[4], parErr[4]);

  double chi2;
  fitMethod( (double*) 0, chi2, &(par[0]), 1, RjetCCgraph, RjetNECgraph, RjetSECgraph);

  // get the error matrix
  minuit->mnemat(&covarquad[0][0], Npar);
  cout.precision(10);
  for(int i = 0; i < Npar; i++) {
    for(int j = 0; j < Npar; j++) cout << covarquad[i][j] << " ";
    cout << endl;
  }
  cout << endl;

  cout << "Minimum at:" << endl
       << "p0 = " << par[0] << " +/- " << parErr[0] << endl
       << "p1 = " << par[1] << " +/- " << parErr[1] << endl
       << "p2 = " << par[2] << " +/- " << parErr[2] << endl
       << "p3 = " << par[3] << " +/- " << parErr[3] << endl
       << "p4 = " << par[4] << " +/- " << parErr[4] << endl;
  cout << " With chi2 = " << chi2 << endl;

  if (flag==1) { //fit errors, linear fit case
    fErrQuad = new TF1("fErrLin", "sqrt([0] + 2*[1] * log(x/100) + [2] * log(x/100) * log(x/100))");
    fErrQuad->SetParameters(covarquad[0][0], covarquad[0][1], covarquad[1][1]);
  } else {
    fErrQuad = new TF1("fErrQuad", 
		       "sqrt([0]+log(x/100)*(2*[1]+log(x/100)*(2*[2]+[3]+log(x/100)*(2*[4]+[5]*log(x/100)))))");
    fErrQuad->SetParameters(covarquad[0][0], covarquad[0][1], covarquad[0][2], 
			    covarquad[1][1], covarquad[1][2], covarquad[2][2]);
  }
  
} 
// fitResponse    

// ______________________________________________________________
// ______________________________________________________________
// ______________________________________________________________

void fitMethod(double* grad, double& chi2, double* par, int flag, 
	       TGraphErrors* RjetCCgraph, TGraphErrors* RjetNECgraph, TGraphErrors* RjetSECgraph) {



  /*********************************************
   *   p0 + p1 * log(E') + p2 * log^2(E')      *
   *   p3 - ECS cryostat factor                *
   *   p4 - ECN cryostat factor                *
   *********************************************/

  if (flag) {
    chi2 = 0;

    for(int i = 0; i < RjetCCgraph->GetN(); i++) {
      const double x = log(RjetCCgraph->GetX()[i] / E0);
      const double y = RjetCCgraph->GetY()[i];
      const double err_y = RjetCCgraph->GetErrorY(i);
      const double pred = par[0] + par[1] * x + par[2] * x * x;

      chi2 += (err_y) ? sqr((pred - y) / err_y) : 1e30;
    }

    for(int i = 0; i < RjetSECgraph->GetN(); i++) {
      const double x = log(RjetSECgraph->GetX()[i] / E0);
      const double y = RjetSECgraph->GetY()[i];
      const double err_y = RjetSECgraph->GetErrorY(i);

      const double pred = par[3] * (par[0] + par[1] * x + par[2] * x * x);

      chi2 += (err_y) ? sqr((pred - y) / err_y) : 1e30;
    }

    for(int i = 0; i < RjetNECgraph->GetN(); i++) {
      const double x = log(RjetNECgraph->GetX()[i] / E0);
      const double y = RjetNECgraph->GetY()[i];
      const double err_y = RjetNECgraph->GetErrorY(i);

      const double pred = par[4] * (par[0] + par[1] * x + par[2] * x * x);

      chi2 += (err_y) ? sqr((pred - y) / err_y) : 1e30;
    }

    std::cout << "   p0 = " << par[0] << "   chi2 = " << chi2 << std::endl;
  }
}
// fitMethod


#endif
