// *
// *   File:      Response_draw.cpp
// *   Purpose:   Program to analyze output of Response.cpp
// *   Author:    Jiri Kvita 
// *   Created:   27 Aug 2004 from Closure_draw.cpp
// *   Version:   $Id: Response_draw.cpp,v 1.6 2004/10/02 02:06:36 kvita Exp $
// *

#include <TROOT.h>
#include <TH1F.h> 
#include <TH2F.h>
#include <TH3F.h>
#include <TProfile.h>
#include <TF1.h>
#include <TGraphErrors.h>
#include <TLegend.h>
#include <TCanvas.h>
#include <TBrowser.h>
#include <TFile.h>
#include <TLatex.h>
#include <TLegend.h>
#include <TApplication.h>

#include <TMinuit.h>
#include <TFitter.h>

#include "histosR.cpp"
#include "mytools.h"
#include "mydrawtools.hpp"
#include "standardsetup.C"
#include "fitResponse.cpp"

#include <fstream>
#include <string.h>
#include <stdio.h>

#define TMyProfile TProfile
//#define TMyProfile TH1F

using namespace std;

Int_t main(Int_t argc, char *argv[])
{

  // =========================================================================
  // =========================================================================
  // =========================================================================

  const Int_t nfiles=2;
  const Int_t canvases=11;

  Int_t _rebin=10;
  int rebin[LnEprimebins];
  for (int t = 0; t < LnEprimebins; ++t) rebin[t]=_rebin;
  rebin[0]=30;rebin[1]=20;

  
  char* analysis="Z";
  GenerateHistogramNames(analysis);//important!

  //Legends stuff
  TLegend *legeta[nfiles],  *legeprime[nfiles][4];
  TLegend *legdiff[nfiles], *leg_RjetEprime[nfiles];

  TLegend *FitLegCF[nfiles],*LegNOCF[nfiles];

  Float_t lx1=0.155,ly1=0.175,lx2=0.40,ly2=0.36;

 //profiles' y axis limits, colors etc.
  Float_t maxR=1.05,minR=0.4;
  Float_t maxRfit=1.05,minRfit=0.6;
  Float_t MarkerSize=0.8;
  Int_t medianCol=2, meanCol=1, gaussCol=8;
  Int_t meanMarker=20, medianMarker=20, gaussMarker=29, Marker=20;
  Int_t CalCol[3] = {2,4,8};
  //(Edet-E')/E'
  Float_t maxDiff=0.55,minDiff=0.;

  TH1F *Rjet[nfiles], *Eprime[nfiles];
  TH2F *RjetVsEprime[nfiles][4], *RjetVsJetDetEta[nfiles], *EprimeVsEjetJES[nfiles];

  //Rjet(E'), eta dependence
  TProfile *RjetVsEprimeMeanProf[nfiles][4], *RjetVsJetDetEtaProf[nfiles], *EprimeVsEjetJESProf[nfiles];
  TH1F *RjetVsEprimeMedianProf[nfiles][4],   *RjetVsJetDetEtaMedianProf[nfiles];
  TH1F *RjetVsEprimeGaussProf[nfiles][4],    *RjetVsJetDetEtaGaussProf[nfiles];

  //Edet(E'), (Edet-E')/E'
  TH2F *EdetVsEprime[nfiles][4], *NormEdiffVsEprime[nfiles][4];
  TProfile *NormEdiffVsEprimeProf[nfiles][4];
  TMyProfile *EdetVsEprimeProf[nfiles][4];
 
  //Rjet(Edet)
  TGraphErrors *RjetVsEdetMeanGraph[nfiles][4];
  TGraphErrors *RjetVsEdetMedianGraph[nfiles][4];
  TGraphErrors *RjetVsEdetGaussGraph[nfiles][4];

  //Rjet(Edet) + Cryostat Factor
  TGraphErrors *RjetVsEdetMeanGraphCF[nfiles][2];
  TGraphErrors *RjetVsEdetMedianGraphCF[nfiles][2];
  TGraphErrors *RjetVsEdetGaussGraphCF[nfiles][2];

  //Rjet(Edet) + Cryostat Factor, All cal parts together
  TGraphErrors *RjetVsEdetMeanGraphCFAll[nfiles];
  TGraphErrors *RjetVsEdetMedianGraphCFAll[nfiles];
  TGraphErrors *RjetVsEdetGaussGraphCFAll[nfiles];

  int nptsAll=0;//for a combined graph of all cal parts
  float  RjetCFXMeanAll[maxBins], RjetCFMeanErrAll[maxBins],
    RjetCFXMedianAll[maxBins], RjetCFMedianErrAll[maxBins],
    RjetCFXGaussAll[maxBins], RjetCFGaussErrAll[maxBins],
    EdetXAll[maxBins], EdetErrAll[maxBins];
  
  TF1 *RjetFitMean[nfiles], *RjetFitMedian[nfiles], *RjetFitGauss[nfiles], *RjetFitMedianCConly[nfiles];
  TF1 *SasaFit[nfiles];
 
  // fit using minuit: error of the fit:
  TF1* fErrQuad;

  TLatex *text[nfiles][4];

  //E' strips
  Int_t eprimestripcolor=50, etastripcolor=9;
  const Int_t maxNstrips=300;
  TH1F *EprimeStrip[nfiles][maxNstrips],EtaStrip[nfiles][maxNstrips];
  TH1F *EdetStrip[nfiles][maxNstrips];

  char help[1000],help2[1000];

  // =========================================================================
  // =========================================================================
  // =========================================================================

#ifndef _CINT_
  TApplication theApp("qitek's GUI", &argc, argv);
#endif

 //  gROOT->LoadMacro("standardsetup.C");
  setup();
  //  gStyle->SetOptStat(111111);

  gStyle->SetOptFit(1111);
 
  char* datatype[nfiles]={"data","MC"}; 

  //pass2 2EMhighpt, OneJetAndMore (exclusive), jetcorr5.3
  char* filename[nfiles]={"ZjetResponse_pass2exclusive_2EMhighpt_Stradivarius_JetCorr5.3_8bins_notrig.root",
			  "ZjetResponse_Zj_eej_Stradivarius_MC_t42_vtxNewskim_6bins.root"};
  
  // 2EM test sample:
  //char* filename[nfiles]={"ZjetResponse_CSskim_Stradivarius_A1_2EM_12GeV.root",
  //		  "ZjetResponse_Zj_eej_Stradivarius_MC_t42_vtxNewskim.root"};

  //data jetcorr 5.1:
  //char* filename[nfiles]={"ZjetResponse_CSskim_Stradivarius_A1_topskim2EM.root",
  //		  "ZjetResponse_Zj_eej_Stradivarius_MC_t42_vtxNewskim.root"};

  /* default:
  char* filename[nfiles]={"ZjetResponse_CSskim_2EMhighpt_Stradivarius_A1_datavtxMediumSkimAll.root",
			  "ZjetResponse_Zj_eej_Stradivarius_MC_t42_vtxNewskim.root"};
  */
  char filebasename[nfiles][500];
  for (Int_t k=0;k<nfiles;++k) {
    string ss1=filename[k],ss2="";
    //replace ".root" by "" so that one can save canvas names as ps; ROOT would save a root file, stupid
    ss1.replace(strlen(ss1.c_str())-5,5,ss2);
    //    (filebasename[k])=new char[strlen(ss1.c_str())+1];
    strcpy(filebasename[k],ss1.c_str());
    cout << filebasename[k] << endl;
  }

  TFile* file[nfiles];
  for (Int_t i=0;i<nfiles;++i) {
    file[i]= new TFile(filename[i]);
    if (!file[i]) { cout << "File "<<filename[i]<< " not found! Exiting...\n"; return 1;}
  }
  
  TMyCanvasAttributes* CanvAttr[nfiles][canvases];
  for (Int_t i=0; i<nfiles; ++i) {
    // TMyCanvasAttributes::TMyCanvasAttributes(name,     drawme,divx,divy);
    CanvAttr[i][0]  = new TMyCanvasAttributes("RjetEprime",      1,2,2);
    CanvAttr[i][1]  = new TMyCanvasAttributes("ResponseCalParts",1,3,2);
    CanvAttr[i][2]  = new TMyCanvasAttributes("ResponseAllCal",  1,2,2);
    CanvAttr[i][3]  = new TMyCanvasAttributes("ResponseTogether",1,1,1);
    CanvAttr[i][4]  = new TMyCanvasAttributes("EprimeStrips",    1,3,2);
    CanvAttr[i][5]  = new TMyCanvasAttributes("EdetVsEprime",    1,1,2);
    CanvAttr[i][6]  = new TMyCanvasAttributes("EdetStrips",      1,3,3);

    CanvAttr[i][7]  = new TMyCanvasAttributes("RjetEdetParts",   1,3,2); 
    CanvAttr[i][8]  = new TMyCanvasAttributes("RjetEdet",        1,1,1);
    CanvAttr[i][9]  = new TMyCanvasAttributes("RjetEdetCF",      1,1,1);
    
    CanvAttr[i][10] = new TMyCanvasAttributes("RjetFit",         1,1,1);
  }

  Int_t canv_height=350, canv_width=500, canv_y=5, canv_x=5, canv_offset_x=50, canv_offset_y=16, file_offset=300;
  TCanvas* (Canv[nfiles][canvases]);
  TCanvas *helpcnv;
  for (Int_t i=0; i<nfiles; ++i) {
    Int_t count=0;
    for (Int_t k=0; k<canvases;++k) {
      if (CanvAttr[i][k]->GetDrawMe()) {
	cout << "Creating canvas #" << k << " for " << datatype[i] << "\n";
	char tmp[1000];strcpy(tmp,CanvAttr[i][k]->GetName());
	strcat(tmp,"_");
	strcat(tmp,filebasename[i]);
	Canv[i][k] = new TCanvas((const char*)tmp, (const char*)tmp,
				 canv_x+count*canv_offset_x,canv_y+count*canv_offset_y+i*file_offset,canv_width,canv_height);
	Canv[i][k]->Divide(CanvAttr[i][k]->GetDivisionX(),CanvAttr[i][k]->GetDivisionY());
	Canv[i][k]->Draw();
	count++;
      }
    }
  }

  // =========================================================================
  // =========================================================================
  // ========================================================================= 
  
  //fi = file index, ci = canvas index
  for (Int_t fi=0; fi<nfiles; ++fi) {
    
    int nptsAll=0;//for a combined graph of all cal parts! needs to be zeroed here!!!

   dashline();
    cout << "Processing file " << file[fi]->GetName() << endl;
    //  char d;cin >> d;
    Int_t ci=0;
   // ---------------------------------------------------------------- 

    if (CanvAttr[fi][ci]->GetDrawMe()) { 
      ci=0;
      Rjet[fi] = (TH1F*) file[fi]->Get("Response/Rjet");
      Canv[fi][ci]->cd(1);
      if (Rjet[fi])  {
	Rjet[fi]->Rebin(10);
	SetHistoStyle(Rjet[fi],2,Marker,MarkerSize,"Rjet","events/0.05");
	Rjet[fi]->Draw("e1");
      }
      
      Eprime[fi] = (TH1F*) file[fi]->Get("Response/Eprime");
      Canv[fi][ci]->cd(2);
      if (Eprime[fi])    {
	SetHistoStyle(Eprime[fi],8,Marker,MarkerSize,"E'","events");
	Eprime[fi]->Draw("e1");
      }
      
      EprimeVsEjetJES[fi] = (TH2F*) file[fi]->Get("Response/EprimeVsEjetJES");
      Canv[fi][ci]->cd(3);
      if (EprimeVsEjetJES[fi])  {
	EprimeVsEjetJES[fi]->Draw("colz");
	strcpy(help,"");
	sprintf(help,"%s_%s_%s",EprimeVsEjetJES[fi]->GetName(), (char*)datatype[fi],"_prof");
	EprimeVsEjetJESProf[fi]=EprimeVsEjetJES[fi]->ProfileX((char*)help);
	if (EprimeVsEjetJESProf[fi]) {
	  Canv[fi][ci]->cd(4);
	  char* tmp1="JES E_{jet}";char* tmp2="E'";
	  SetHistoStyle(EprimeVsEjetJESProf[fi],9,meanMarker,MarkerSize,"JES E_{jet}","E'");
	  EprimeVsEjetJESProf[fi]->Draw("e1");
	}
      }
    }//canvas0


    // ---------------------------------------------------------------- 
    Int_t baseindex=1;
    for (Int_t c=0;c<4;++c) {
      //loop over different Cal parts
      //      ci=c+baseindex;
      ci=baseindex+1*(c==3);
      if (CanvAttr[fi][ci]->GetDrawMe()) { 
	//	strcpy(help,"Response/");   strcat(help, (char*)RjetVsEprime_name[c]);
	sprintf(help,"%s%s",ResponseDir,RjetVsEprime_name[c]);
	RjetVsEprime[fi][c] = (TH2F*) file[fi]->Get((char*)help);
	if (c<3) Canv[fi][ci]->cd(1+c);
	else Canv[fi][ci]->cd(1); //only when drawing all!
	if (RjetVsEprime[fi][c])   {
	  SetHistoStyle(RjetVsEprime[fi][c],"E'","R_{jet}");
	  gPad->SetLogx();
	  RjetVsEprime[fi][c]->Draw("colz");
	}
	
	//	strcpy(help,"Response/");   strcat(help, (char*)RjetVsEprimeMeanProf_name[c]);
	sprintf(help,"%s%s",ResponseDir,RjetVsEprimeProf_name[c]);
	RjetVsEprimeMeanProf[fi][c] = (TProfile*) file[fi]->Get((char*)help);
	if (c<3) Canv[fi][ci]->cd(4+c);
	else Canv[fi][ci]->cd(3); //only when drawing all!
	gPad->SetLogx();
	if (RjetVsEprimeMeanProf[fi][c])   {
	  SetHistoStyle(RjetVsEprimeMeanProf[fi][c],meanCol,meanMarker,MarkerSize,"E'","mean R_{jet}",minR,maxR);
	  RjetVsEprimeMeanProf[fi][c]->DrawCopy("e1");
	}
	
	//median profile
	sprintf(help,"%s_%s",datatype[fi],CalPart[c]);
	RjetVsEprimeMedianProf[fi][c] = GetMyProfile(RjetVsEprime[fi][c], (char*)help,"median");
	if (RjetVsEprimeMedianProf[fi][c]) {
	  SetHistoStyle(RjetVsEprimeMedianProf[fi][c],medianCol,medianMarker,MarkerSize,"E'","median R_{jet}",minR,maxR);
	  RjetVsEprimeMedianProf[fi][c]->DrawCopy("e1same");
	}

	//gauss profile 
	sprintf(help,"%s_%s",datatype[fi],CalPart[c]);
	  Float_t nsigma=2.;
	  RjetVsEprimeGaussProf[fi][c] = GetGaussProfile(RjetVsEprime[fi][c], (char*)help,LnEprimebins,(int*)rebin,nsigma);
	  if (RjetVsEprimeGaussProf[fi][c]) {
	    SetHistoStyle(RjetVsEprimeGaussProf[fi][c],gaussCol,gaussMarker,MarkerSize,"E'","gauss fit R_{jet}",minR,maxR);
	    RjetVsEprimeGaussProf[fi][c]->DrawCopy("e1same");
	  }
	
	if ((RjetVsEprimeMedianProf[fi][c])||(RjetVsEprimeMeanProf[fi][c])||(RjetVsEprimeGaussProf[fi][c])) {
	  gStyle->SetFillColor(10);
	  legeprime[fi][c] = new TLegend(lx1,ly1,lx2,ly2); 
	  //legeprime[fi][c] = new TLegend(lx1,ly1,lx2,ly2,"R_{jet}(E')");
	  if (RjetVsEprimeMeanProf[fi][c])   legeprime[fi][c]->AddEntry(RjetVsEprimeMeanProf[fi][c],   "Mean","p");
	  if (RjetVsEprimeMedianProf[fi][c]) legeprime[fi][c]->AddEntry(RjetVsEprimeMedianProf[fi][c], "Median","p");
	  if (RjetVsEprimeGaussProf[fi][c])  legeprime[fi][c]->AddEntry(RjetVsEprimeGaussProf[fi][c],  "Gauss","p");
	  legeprime[fi][c]->Draw();
	}
	

      }//if canvas
    }//Cal parts loop

    // ---------------------------------------------------------------- 
      ci=2;//all cal parts!
      if (CanvAttr[fi][ci]->GetDrawMe()) { 

	strcpy(help,"Response/");   strcat(help,RjetVsJetDetEta_name);
	RjetVsJetDetEta[fi] = (TH2F*) file[fi]->Get((char*)help);
	Canv[fi][ci]->cd(2);
	if (RjetVsJetDetEta[fi]) {
	  SetHistoStyle(RjetVsJetDetEta[fi],"jet det #eta","R_{jet}/0.1");
	  RjetVsJetDetEta[fi]->Draw("colz");
	}
	
	strcpy(help,"Response/");   strcat(help,RjetVsJetDetEtaProf_name);
	RjetVsJetDetEtaProf[fi] = (TProfile*) file[fi]->Get((char*)help);
	Canv[fi][ci]->cd(4);
	if (RjetVsJetDetEtaProf[fi])   {
	  SetHistoStyle(RjetVsJetDetEtaProf[fi],meanCol,meanMarker,MarkerSize,"jet det #eta","mean R_{jet}",minR,maxR);
	  RjetVsJetDetEtaProf[fi]->Draw("e1");
	}
	
	sprintf(help,"%s", (char*)datatype[fi]);
	RjetVsJetDetEtaMedianProf[fi] = GetMyProfile(RjetVsJetDetEta[fi], (char*)help,"median");
	if (RjetVsJetDetEtaMedianProf[fi]) {
	  SetHistoStyle(RjetVsJetDetEtaMedianProf[fi],medianCol,medianMarker,MarkerSize,"jet det #eta","median R_{jet}",minR,maxR);
	  RjetVsJetDetEtaMedianProf[fi]->Draw("e1same");
	}
	
	if ((RjetVsJetDetEtaMedianProf[fi])&&(RjetVsJetDetEtaProf[fi])) {
	  gStyle->SetFillColor(10);
	  legeta[fi] = new TLegend(lx1,ly1,lx2,ly2);
	  legeta[fi]->AddEntry(RjetVsJetDetEtaProf[fi],"Mean","p");
	  legeta[fi]->AddEntry(RjetVsJetDetEtaMedianProf[fi],"Median","p");
	  legeta[fi]->Draw();
	}

      //..................................................................
      }//draw canvas

      // ----------------------------------------------------------------
      ci=3;
      if (CanvAttr[fi][ci]->GetDrawMe()) { 
        Canv[fi][ci]->cd(1);      
	for (Int_t c=0;c<3;++c) {
	  SetHistoStyle(RjetVsEprimeMedianProf[fi][c], (Int_t)CalCol[c],medianMarker,MarkerSize,"E'","median R_{jet}",minR,maxR);
	  gPad->SetLogx();
	  if (c>0) RjetVsEprimeMedianProf[fi][c]->DrawCopy("e1same");
	  else  RjetVsEprimeMedianProf[fi][c]->DrawCopy("e1");
	}
	Canv[fi][ci]->cd(1); 
	if ( (RjetVsEprimeMedianProf[fi][0]) || (RjetVsEprimeMedianProf[fi][1]) || (RjetVsEprimeMedianProf[fi][2]) ) {
	  leg_RjetEprime[fi] = new TLegend(lx1,ly1,lx2,ly2);
	  if (RjetVsEprimeMedianProf[fi][0]) leg_RjetEprime[fi]->AddEntry(RjetVsEprimeMedianProf[fi][0],"CC","p");
	  if (RjetVsEprimeMedianProf[fi][1]) leg_RjetEprime[fi]->AddEntry(RjetVsEprimeMedianProf[fi][1],"NEC","p");
	  if (RjetVsEprimeMedianProf[fi][2]) leg_RjetEprime[fi]->AddEntry(RjetVsEprimeMedianProf[fi][2],"SEC","p");
	  leg_RjetEprime[fi]->Draw();
	}    


      }
      // ----------------------------------------------------------------
      ci=4;
      if (CanvAttr[fi][ci]->GetDrawMe()) { 
	int c=0; //CC
	char* basename="E'";
	sprintf(help,"$s in %s",basename,CalPart[c]);
	Int_t localrebin=1;
	if (RjetVsEprime[fi][c]) {
	  GetStrips(RjetVsEprime[fi][c], (TH1F**)(EprimeStrip[fi]),basename, (char*)datatype[fi],eprimestripcolor,localrebin);
	  int kkk=1;
	  for (Int_t kk=1;kk<=RjetVsEprime[fi][c]->GetXaxis()->GetNbins();++kk) {
	      Canv[fi][ci]->cd(kkk); 
	      gPad->SetLogy();
	      if (EprimeStrip[fi][kk]) 
		if (EprimeStrip[fi][kk]->GetMaximum()>0) {
		  EprimeStrip[fi][kk]->Rebin(rebin[kk-1]);
		  EprimeStrip[fi][kk]->SetLineWidth(2);
		  EprimeStrip[fi][kk]->SetMinimum(0.7);
		  kkk++;
		  Float_t mean,sigma,error;
		  FitGauss(EprimeStrip[fi][kk], 1, 2, &mean, &sigma, &error, "Q");
		  //cout << "Strip #"<<kk << ": mean="<<(mean)<<", sigma="<<(sigma)<<", error="<<(error)<<endl;
		  if (kk > 1) EprimeStrip[fi][kk]->Draw();
		}
	  }//for
	}//if TH2F
	
      }//canvas4
      
      // ----------------------------------------------------------------
      ci=5;
      if (CanvAttr[fi][ci]->GetDrawMe()) {  
	int cnst=-1;//-1 or 0
	for (int c=0; c<3;++c ) {
	  strcpy(help,"Response/");
	  strcat(help,EdetVsEprime_name[c]);
	  EdetVsEprime[fi][c]= (TH2F*) file[fi]->Get((char*)help);
	  if (EdetVsEprime[fi][c]) {
	    SetHistoStyle(EdetVsEprime[fi][c],2,Marker,MarkerSize,"E'","E_{det}");
	    //Canv[fi][ci]->cd(1+cnst); 
	    //	    EdetVsEprime[fi][c]->Draw("colz");
	  }


	  strcpy(help,"Response/");
	  strcat(help,NormEdiffVsEprimeProf_name[c]);
	  NormEdiffVsEprimeProf[fi][c]= (TProfile*) file[fi]->Get((char*)help);
	  if (NormEdiffVsEprimeProf[fi][c]) {
	    SetHistoStyle(NormEdiffVsEprimeProf[fi][c], (Int_t)CalCol[c],Marker,MarkerSize,"E'","(E_{det}-E')/E'",minDiff,maxDiff);
	    Canv[fi][ci]->cd(2+cnst); 
	    gPad->SetLogx();
	    if (c == 0)   NormEdiffVsEprimeProf[fi][c]->Draw("e1");
	    else NormEdiffVsEprimeProf[fi][c]->Draw("e1same");
	  }
	  
	  
	  strcpy(help,"Response/");
	  strcat(help,EdetVsEprimeProf_name[c]);
	  EdetVsEprimeProf[fi][c]= (TMyProfile*) file[fi]->Get((char*)help);
	  //	  EdetVsEprimeProf[fi][c]= GetMyProfile(EdetVsEprime[fi][c], "Prof", "mean");
	  if (EdetVsEprimeProf[fi][c]) {
	    SetHistoStyle(EdetVsEprimeProf[fi][c], (Int_t)CalCol[c],Marker,MarkerSize,"E'","E_{det}",
			  EdetVsEprimeProf[fi][c]->GetXaxis()->GetXmin(),EdetVsEprimeProf[fi][c]->GetXaxis()->GetXmax());
	    Canv[fi][ci]->cd(3+cnst); 
	    gPad->SetLogx();gPad->SetLogy();
	    if (c == 0)   EdetVsEprimeProf[fi][c]->Draw("e1");
	    else EdetVsEprimeProf[fi][c]->Draw("e1same");
	  }
	}//for cal parts

	Canv[fi][ci]->cd(2+cnst); 
	if ( (NormEdiffVsEprimeProf[fi][0]) || (NormEdiffVsEprimeProf[fi][1]) || (NormEdiffVsEprimeProf[fi][2]) ) {
	  legdiff[fi] = new TLegend(lx1,ly1,lx2,ly2);
	  if (NormEdiffVsEprimeProf[fi][0]) legdiff[fi]->AddEntry(NormEdiffVsEprimeProf[fi][0],"CC","p");
	  if (NormEdiffVsEprimeProf[fi][1]) legdiff[fi]->AddEntry(NormEdiffVsEprimeProf[fi][1],"NEC","p");
	  if (NormEdiffVsEprimeProf[fi][2]) legdiff[fi]->AddEntry(NormEdiffVsEprimeProf[fi][2],"SEC","p");
	  legdiff[fi]->Draw();
	}   

      }//draw canvas

      // ----------------------------------------------------------------
      ci=6;//Edet strips
      if (CanvAttr[fi][ci]->GetDrawMe()) { 
	Canv[fi][ci]->cd(1); 
	int c=1;
	char* basename="E_{det}";
	sprintf(help,"$s in %s",basename,CalPart[c]);
	Int_t localrebin=1;
	if (EdetVsEprime[fi][c]) {
	  GetStrips(EdetVsEprime[fi][c], (TH1F**)(EdetStrip[fi]),basename, (char*)datatype[fi],eprimestripcolor,localrebin);
	  for (Int_t kk=1;kk<=RjetVsEprime[fi][c]->GetXaxis()->GetNbins();++kk) {
	      if (EdetStrip[fi][kk]) {
		//		EdetStrip[fi][kk]->Rebin(rebin[kk-1]);	
		//EdetStrip[fi][kk]->Rebin(localrebin);
		EdetStrip[fi][kk]->SetLineWidth(2);
		EdetStrip[fi][kk]->GetXaxis()->SetRange(0.,120.);
		Float_t mean,sigma,error;
		//FitGauss(EdetStrip[fi][kk], 1, 2, &mean, &sigma, &error, "Q");
		//cout << "Strip #"<<kk << ": mean="<<(mean)<<", sigma="<<(sigma)<<", error="<<(error)<<endl;
		
		if ( (kk > 1) && (kk < 10)) {
		  //		  cout << "fi=" << fi << " ci=" << ci << " kk=" << kk << endl;
		  Canv[fi][ci]->cd(kk); 
		  EdetStrip[fi][kk]->Draw();
		}
	      }
	  }//for
	}//if TH2F
	
      }//canvas4

      // ----------------------------------------------------------------
      ci=7;//Rjet Edet
      if (CanvAttr[fi][ci]->GetDrawMe()) {  

	int npts[4];//number of points in final Rjet(Edet) plots for different modules

	for (int c = 0; c < 3; ++c) {
	  //	  cout <<"c="<<c<<endl;
	  float RjetXMean[maxBins],  RjetMeanErr[maxBins], 
	    RjetXMedian[maxBins],  RjetMedianErr[maxBins], 
	    RjetXGauss[maxBins],  RjetGaussErr[maxBins],
	    RjetCFXMean[maxBins], RjetCFMeanErr[maxBins],
	    RjetCFXMedian[maxBins], RjetCFMedianErr[maxBins],
	    RjetCFXGauss[maxBins], RjetCFGaussErr[maxBins],
	    EdetX[maxBins], EdetErr[maxBins];
	  //Rjet(Edet)
	  int allnpts = EdetVsEprimeProf[fi][c]->GetXaxis()->GetNbins();
	  npts[c]=0;//will count actuall number of nonzero Rjets to be filled into grapth

	  for (int i = 0; i < allnpts; ++i) {
	    //I'm not taking under/over-flow
	    //	    cout << "i="<<i<<endl;

	    if (RjetVsEprimeMeanProf[fi][c]->GetBinContent(i+1) > 0.) {
	      RjetXMean[npts[c]]     = RjetVsEprimeMeanProf[fi][c]->GetBinContent(i+1);
	      RjetMeanErr[npts[c]]   = RjetVsEprimeMeanProf[fi][c]->GetBinError(i+1);
	      RjetXMedian[npts[c]]   = RjetVsEprimeMedianProf[fi][c]->GetBinContent(i+1);
	      RjetMedianErr[npts[c]] = RjetVsEprimeMedianProf[fi][c]->GetBinError(i+1);
	      RjetXGauss[npts[c]]    = RjetVsEprimeGaussProf[fi][c]->GetBinContent(i+1);
	      RjetGaussErr[npts[c]]  = RjetVsEprimeGaussProf[fi][c]->GetBinError(i+1);
	      EdetX[npts[c]] = EdetVsEprimeProf[fi][c]->GetBinContent(i+1);
	      EdetErr[npts[c]] = 0.5*(EdetVsEprimeProf[fi][c]->GetBinWidth(i+1));
	      
	      if ( (c > 0) && (c < 3) ) { //ECN or ECS, perform cryostat factor correction:

		if (!strcmp(datatype[fi], "data")) {
		  //data
		  RjetCFXMean[npts[c]]     = (RjetXMean[npts[c]])     / (FCryoData_t42[c-1]);
		  RjetCFMeanErr[npts[c]]   = sqrt( sqr( (RjetMeanErr[npts[c]])/(FCryoData_t42[c-1]) ) +
						   sqr( (RjetXMean[npts[c]])*(FCryoDataError_t42[c-1])/sqr(FCryoData_t42[c-1]) ) );

		  RjetCFXMedian[npts[c]]   = (RjetXMedian[npts[c]])   / (FCryoData_t42[c-1]);
		  RjetCFMedianErr[npts[c]]   = sqrt( sqr( (RjetMedianErr[npts[c]])/(FCryoData_t42[c-1]) ) +
						     sqr( (RjetXMedian[npts[c]])*(FCryoDataError_t42[c-1])/sqr(FCryoData_t42[c-1]) ) );
		  
		  RjetCFXGauss[npts[c]]    = (RjetXGauss[npts[c]])    / (FCryoData_t42[c-1]);
		  RjetCFGaussErr[npts[c]]   = sqrt( sqr( (RjetGaussErr[npts[c]])/(FCryoData_t42[c-1]) ) +
						     sqr( (RjetXGauss[npts[c]])*(FCryoDataError_t42[c-1])/sqr(FCryoData_t42[c-1]) ) );
		}
		else {
		  //MC
		  RjetCFXMean[npts[c]]     = (RjetXMean[npts[c]])     / (FCryoMC_t42[c-1]);
		  RjetCFMeanErr[npts[c]]   = sqrt( sqr( (RjetMeanErr[npts[c]])/(FCryoMC_t42[c-1]) ) +
						   sqr( (RjetXMean[npts[c]])*(FCryoMCError_t42[c-1])/sqr(FCryoMC_t42[c-1]) ) );	  
		  
		  RjetCFXMedian[npts[c]]   = (RjetXMedian[npts[c]])   / (FCryoMC_t42[c-1]);
		  RjetCFMedianErr[npts[c]]   = sqrt( sqr( (RjetMedianErr[npts[c]])/(FCryoMC_t42[c-1]) ) +
						     sqr( (RjetXMedian[npts[c]])*(FCryoMCError_t42[c-1])/sqr(FCryoMC_t42[c-1]) ) );  
		  
		  RjetCFXGauss[npts[c]]    = (RjetXGauss[npts[c]])    / (FCryoMC_t42[c-1]);
		  RjetCFGaussErr[npts[c]]   = sqrt( sqr( (RjetGaussErr[npts[c]])/(FCryoMC_t42[c-1]) ) +
						    sqr( (RjetXGauss[npts[c]])*(FCryoMCError_t42[c-1])/sqr(FCryoMC_t42[c-1]) ) );

		}
		if (RjetCFXMedian[npts[c]] < 0.7) cout << "LOW CF-corrected RESPONSE FOUND IN MODULE " << CalPart[c] << endl;
		/*	cout << " RjetCFXMean=" << RjetCFXMean[npts[c]] << " RjetCFMeanErr=" << RjetCFMeanErr[npts[c]]
		  << " RjetCFXMedian=" << RjetCFXMedian[npts[c]] << endl << " RjetCFMedianErr=" << RjetCFMedianErr[npts[c]]
		  << " RjetCFXGauss=" << RjetCFXGauss[npts[c]]  << " RjetCFGaussErr=" << RjetCFGaussErr[npts[c]] << endl;
		  dashline();
		  cout << " RjetXMean=" << RjetXMean[npts[c]] << " RjetMeanErr=" << RjetMeanErr[npts[c]]
		  << " RjetXMedian=" << RjetXMedian[npts[c]] << endl << " RjetMedianErr=" << RjetMedianErr[npts[c]]
		  << " RjetXGauss=" << RjetXGauss[npts[c]] << " RjetGaussErr=" << RjetGaussErr[npts[c]] << endl;
		*/
	      }//ECN or ECS
	     

	      //points for a combined graph of all cal part; to be fitted
	      if (c == 0) {
		RjetCFXMeanAll[nptsAll]     = RjetXMean[npts[c]];
		RjetCFMeanErrAll[nptsAll]   = RjetMeanErr[npts[c]];
		RjetCFXMedianAll[nptsAll]   = RjetXMedian[npts[c]];
		RjetCFMedianErrAll[nptsAll] = RjetMedianErr[npts[c]];
		RjetCFXGaussAll[nptsAll]    = RjetXGauss[npts[c]];
		RjetCFGaussErrAll[nptsAll]  = RjetGaussErr[npts[c]];
		EdetXAll[nptsAll]           = EdetX[npts[c]];
		EdetErrAll[nptsAll]         = EdetErr[npts[c]];  
		nptsAll++;
	      } else {
		RjetCFXMeanAll[nptsAll]     = RjetCFXMean[npts[c]];
		RjetCFMeanErrAll[nptsAll]   = RjetCFMeanErr[npts[c]];
		RjetCFXMedianAll[nptsAll]   = RjetCFXMedian[npts[c]];
		RjetCFMedianErrAll[nptsAll] = RjetCFMedianErr[npts[c]];
		RjetCFXGaussAll[nptsAll]    = RjetCFXGauss[npts[c]];
		RjetCFGaussErrAll[nptsAll]  = RjetCFGaussErr[npts[c]];
		EdetXAll[nptsAll]           = EdetX[npts[c]];
		EdetErrAll[nptsAll]         = EdetErr[npts[c]];
		nptsAll++;
	      }

	      ++npts[c];

	    }//if Rjet>0.
	  }//for i
	  
	  cout << npts[c] << " graph points for module " << CalPart[c] << ", " << datatype[fi] << endl;
	  RjetVsEdetMeanGraph[fi][c]   = new TGraphErrors(npts[c], (float*)EdetX, (float*)RjetXMean, 
							  (float*)EdetErr, (float*)RjetMeanErr);
	  SetGraphStyle(RjetVsEdetMeanGraph[fi][c],meanCol,meanMarker,MarkerSize,"E_{det}","R_{jet} Mean");
	  RjetVsEdetMedianGraph[fi][c] = new TGraphErrors(npts[c], (float*)EdetX, (float*)RjetXMedian, 
							  (float*)EdetErr, (float*)RjetMedianErr);
	  SetGraphStyle(RjetVsEdetMedianGraph[fi][c],medianCol,medianMarker,MarkerSize,"E_{det}","R_{jet} Median");
	  RjetVsEdetGaussGraph[fi][c]  = new TGraphErrors(npts[c], (float*)EdetX, (float*)RjetXGauss, 
							  (float*)EdetErr, (float*)RjetGaussErr);
	  SetGraphStyle(RjetVsEdetGaussGraph[fi][c],gaussCol,gaussMarker,MarkerSize,"E_{det}","R_{jet} Gauss");

	  if( (c > 0) && (c < 3) ) { //ECN or ECS, perform cryostat factor correction:
	    //Cryostat factor:
	    cout << "Creating scaled graphs for ECs, " << datatype[fi] << "..." << endl;
	    RjetVsEdetMeanGraphCF[fi][c]   = new TGraphErrors(npts[c], (float*)EdetX, (float*)RjetCFXMean,
							      (float*)EdetErr, (float*)RjetCFMeanErr);
	    SetGraphStyle(RjetVsEdetMeanGraphCF[fi][c],meanCol,meanMarker,MarkerSize,"E_{det}","R_{jet} Mean");
	    RjetVsEdetMedianGraphCF[fi][c] = new TGraphErrors(npts[c], (float*)EdetX, (float*)RjetCFXMedian,
							      (float*)EdetErr, (float*)RjetCFMedianErr);
	    SetGraphStyle(RjetVsEdetMedianGraphCF[fi][c],medianCol,medianMarker,MarkerSize,"E_{det}","R_{jet} Median");
	    RjetVsEdetGaussGraphCF[fi][c]  = new TGraphErrors(npts[c], (float*)EdetX, (float*)RjetCFXGauss,
							      (float*)EdetErr, (float*)RjetCFGaussErr);
	    SetGraphStyle(RjetVsEdetGaussGraphCF[fi][c],gaussCol,gaussMarker,MarkerSize,"E_{det}","R_{jet} Gauss");
	    
	  }//if

	  Canv[fi][ci]->cd(1+c); 
	  gPad->SetLogx();
	  //draw the axis only once with the 'A' option:
	  sprintf(help,"%s_%s_%i_%i",datatype[fi],analysis,ci,c);
	  sprintf(help2,"R_{jet}(E_{det}) in %s for %s, NO Cryostat factors applied",CalPart[c],datatype[fi]);
	  TH2F *hp = new TH2F((char*)help, (char*)help2, LnEprimebins, minLnEprime, maxLnEprime,binsRjet,minR,maxR);
	  SetHistoStyle(hp,"E_{det}","R_{jet} Median");
	  hp->SetStats(false);
	  hp->DrawCopy();
	  RjetVsEdetMeanGraph[fi][c]->Draw("P");
	  RjetVsEdetMedianGraph[fi][c]->Draw("P");
	  RjetVsEdetGaussGraph[fi][c]->Draw("P");

	  if ( (c>0) && (c<3) ) {
	    Canv[fi][ci]->cd(4+c); 
	    gPad->SetLogx();
	    //either draw the axis only once with the 'A' option or draw the histogram"
	    sprintf(help,"CF_%s_%s_%i_%i",datatype[fi],analysis,ci,c);
	    sprintf(help2,"R_{jet}(E_{det}) in %s for %s, Cryostat factors applied",CalPart[c],datatype[fi]);
	    TH2F *hp = new TH2F((char*)help, (char*)help2,LnEprimebins,minLnEprime,maxLnEprime,binsRjet,minR,maxR);
	    SetHistoStyle(hp,"E_{det}","R_{jet} Median");
	    hp->SetStats(false);
	    hp->DrawCopy();
	    RjetVsEdetMeanGraphCF[fi][c]->Draw("P");
	    RjetVsEdetMedianGraphCF[fi][c]->Draw("P");
	    RjetVsEdetGaussGraphCF[fi][c]->Draw("P");
	  }
	  
	}//c: call parts

	//graph of all cal part together
	RjetVsEdetMedianGraphCFAll[fi] = new TGraphErrors(nptsAll, (float*)EdetXAll, (float*)RjetCFXMedianAll,
							  (float*)EdetErrAll, (float*)RjetCFMedianErrAll); 
	SetGraphStyle(RjetVsEdetMedianGraphCFAll[fi],medianCol,medianMarker,MarkerSize,"E_{det}","R_{jet} Median");

      }//draw canvas


      // ----------------------------------------------------------------
      ci=8;//Rjet(Edet), NO CF
      if (CanvAttr[fi][ci]->GetDrawMe()) {  
	Canv[fi][ci]->cd(1); 
	gPad->SetLogx();
	sprintf(help,"%s_%s_%i",datatype[fi],analysis,ci);
	sprintf(help2,"R_{jet}(E_{det}) for %s, NO Cryostat factors applied",datatype[fi]);
	TH2F *hp = new TH2F((char*)help, (char*)help2,LnEprimebins,minLnEprime,maxLnEprime,binsRjet,minRfit,maxRfit);
	SetHistoStyle(hp,"E_{det}","R_{jet} Median");

	hp->SetStats(false);
	hp->DrawCopy();
	for (int c = 0; c < 3; ++c) {
	  SetGraphStyle(RjetVsEdetMedianGraph[fi][c],CalCol[c],medianMarker,MarkerSize,"","");
	  RjetVsEdetMedianGraph[fi][c]->Draw("P");
	}

     	LegNOCF[fi] = new TLegend(lx1,ly1,lx2,ly2);
	if (RjetVsEdetMedianGraph[fi][0]) LegNOCF[fi]->AddEntry(RjetVsEdetMedianGraph[fi][0],"CC","p");
	if (RjetVsEdetMedianGraph[fi][1]) LegNOCF[fi]->AddEntry(RjetVsEdetMedianGraph[fi][1],"NEC","p");
	if (RjetVsEdetMedianGraph[fi][2]) LegNOCF[fi]->AddEntry(RjetVsEdetMedianGraph[fi][2],"SEC","p");
	LegNOCF[fi]->Draw();
	
      }//draw canvas



      // ----------------------------------------------------------------

      //all cal part in one graph for fit reasons:

      ci=10;
      if (CanvAttr[fi][ci]->GetDrawMe()) {  

	if (RjetVsEdetMedianGraphCFAll[fi]) {

	  cout << datatype[fi] << ", nptsAll=" << nptsAll << endl;
	  sprintf(help,"RjetFit_%s_Median",datatype[fi]);
	  RjetFitMedian[fi] = new TF1((char*)help, "[0]+[1]*log(x/[3])+[2]*(log(x/[3]))^2", minLnEprime, maxLnEprime);
	  RjetFitMedian[fi]->SetParameters(0.8, 0.08, -0.003, 100);
	  RjetFitMedian[fi]->SetParNames("a","b","c","E_{0}");
	  //	  RjetFitMedian[fi]->SetParLimits(2, -1, 0.);
	  // fix the E_0 parameter: 100 GeV
	  RjetFitMedian[fi]->FixParameter(3,100);
	  RjetFitMedian[fi]->SetLineWidth(2);
	  RjetFitMedian[fi]->SetLineColor(1);

	  Canv[fi][ci]->cd(1); 
	  gPad->SetLogx();
	  sprintf(help, "%s_%s_%i", datatype[fi], analysis,ci);
	  sprintf(help2,"R_{jet}(E_{det}) for %s, Cryostat factors applied",datatype[fi]);
	  TH2F *hp = new TH2F((char*)help, (char*)help2, LnEprimebins, minLnEprime, maxLnEprime, binsRjet, minRfit, maxRfit);
	  SetHistoStyle(hp,"E_{det}","R_{jet} Median");
	  hp->SetStats(false);
	  hp->DrawCopy();
	  RjetVsEdetMedianGraphCFAll[fi]->Fit(RjetFitMedian[fi]);
	  //plot fit prameters!
	  RjetVsEdetMedianGraphCFAll[fi]->Draw("P");

	}//if the graph exists

	
      }//draw canvas


      //Cryostat factor corrected:
      // ----------------------------------------------------------------
      ci=9;//Rjet Edet, Cryostat Factor
      if (CanvAttr[fi][ci]->GetDrawMe()) {  
	Canv[fi][ci]->cd(1); 
	gPad->SetLogx();
	sprintf(help, "%s_%s_%i", datatype[fi], analysis,ci);
	sprintf(help2,"R_{jet}(E_{det}) for %s, Cryostat factors applied",datatype[fi]);
	TH2F *hp = new TH2F((char*)help, (char*)help2, LnEprimebins, minLnEprime, maxLnEprime, binsRjet, minRfit, maxRfit);
	SetHistoStyle(hp,"E_{det}","R_{jet} Median");
	hp->SetStats(false);
	hp->DrawCopy();

	//Fit on CC for data: 12. 10. 2004
	if ( fi == 0 ) {
	  sprintf(help,"RjetFit_%s_MedianCConly",datatype[fi]);
	  RjetFitMedianCConly[fi] = new TF1((char*)help, "[0]+[1]*log(x/[3])+[2]*(log(x/[3]))^2", minLnEprime, maxLnEprime);
	  RjetFitMedianCConly[fi]->SetParameters(0.8, 0.08, -0.003, 100);
	  RjetFitMedianCConly[fi]->SetParNames("a","b","c","E_{0}");
	  //	  RjetFitMedianCConly[fi]->SetParLimits(2, -1, 0.);
	  // fix the E_0 parameter: 100 GeV
	  RjetFitMedianCConly[fi]->FixParameter(3,100);
	  RjetFitMedianCConly[fi]->SetLineWidth(2);
	  RjetFitMedianCConly[fi]->SetLineColor(1);

	  RjetVsEdetMedianGraph[fi][0]->Fit(RjetFitMedianCConly[fi]);
	}
	RjetVsEdetMedianGraph[fi][0]->Draw("P");

	for (int c = 1; c < 3; ++c) {
	  SetGraphStyle(RjetVsEdetMedianGraphCF[fi][c], CalCol[c],medianMarker, MarkerSize, "", "");
	  RjetVsEdetMedianGraphCF[fi][c]->Draw("P");
	}


	if ( fi == 1 ) {
	  SasaFit[fi]=new TF1("gamma","[0]+[1]*log(x/[3])+[2]*(log(x/[3]))^2", minLnEprime, maxLnEprime);
	  SasaFit[fi]->SetParameters(0.84187,0.05999,-0.0054,100);
	  SasaFit[fi]->SetLineStyle(2);
	  SasaFit[fi]->SetLineColor(6);
	  SasaFit[fi]->DrawCopy("same");
	} else {
	  SasaFit[fi]=new TF1("gamma","[0]+[1]*log(x/[3])+[2]*(log(x/[3]))^2", minLnEprime, maxLnEprime);
	  SasaFit[fi]->SetParameters(0.79688,0.07262,0.001993,100);//p2>0!!!
	  SasaFit[fi]->SetLineStyle(2);
	  SasaFit[fi]->SetLineColor(6);
	  SasaFit[fi]->DrawCopy("same");
	}

	//Draw the fit line from canvas #10 (see above)
	//all cal parts for MC:
	if (( fi == 1) && (RjetFitMedian[fi])) {
	  RjetFitMedian[fi]->Draw("same");
	}
	//only CC for data:
	if (( fi == 1) && (RjetFitMedianCConly[fi])) {
	  //	  RjetFitMedianCConly[fi]->Draw("same");
	}
	
	FitLegCF[fi] = new TLegend(lx1,ly1,lx2,ly2);
	if (RjetVsEdetMedianGraph[fi][0]) FitLegCF[fi]->AddEntry(RjetVsEdetMedianGraph[fi][0],"CC","p");
	if (RjetVsEdetMedianGraphCF[fi][1]) FitLegCF[fi]->AddEntry(RjetVsEdetMedianGraphCF[fi][1],"NEC","p");
	if (RjetVsEdetMedianGraphCF[fi][2]) FitLegCF[fi]->AddEntry(RjetVsEdetMedianGraphCF[fi][2],"SEC","p");

	if ( (fi == 0)  && (RjetFitMedianCConly[fi]) )  FitLegCF[fi]->AddEntry(RjetFitMedianCConly[fi],"CC fit only","l");
	if ( (fi == 1)  && (RjetFitMedian[fi]) )  FitLegCF[fi]->AddEntry(RjetFitMedian[fi],"CC+ECs fit","l");

	if (  (SasaFit[fi]) )  FitLegCF[fi]->AddEntry(SasaFit[fi],"#gamma+jet fit, Sasha","l");
	FitLegCF[fi]->Draw();


	
	TF1* tmp;
	if  (fi == 0) tmp=RjetFitMedianCConly[fi]; else tmp=RjetFitMedian[fi];

	if (tmp) {
	  float offy=0.06, fsize=0.037, x0=0.18, y0=0.78;
	  int fcol=9;
	  for(int k=0;k<4;++k) {
	    sprintf(help,"%s = %5.4f #pm %5.4f",tmp->GetParName(k),tmp->GetParameter(k),tmp->GetParError(k));
	    text[fi][k] = new TLatex(x0,y0-k*offy,(char*)help);
	    text[fi][k]->SetTextSize(fsize);
	    text[fi][k]->SetNDC();
	    text[fi][k]->SetTextColor(fcol);
	    text[fi][k]->Draw();
	  }
	  int k=4;
	  text[fi][k] = new TLatex(x0,y0+offy,"Fit: a + b log(E_{det}/E_{0}) + c log^{2}(E_{det}/E_{0})");
	  text[fi][k]->SetTextSize(fsize);
	  text[fi][k]->SetNDC();
	  text[fi][k]->SetTextColor(fcol);
	  text[fi][k]->Draw();

	}

      }//draw canvas
      // ----------------------------------------------------------------
      // ----------------------------------------------------------------
      

      int flag=0;
      double covarquad[Npar][Npar];
      //      TFitter* fitter = 0;//new TFitter(Npar);
      if  ( RjetVsEdetMedianGraph[fi][0] && RjetVsEdetMedianGraph[fi][1] && RjetVsEdetMedianGraph[fi][2] )
	//	fitResponse(Npar,  RjetCCgraph,  RjetNECgraph,  RjetSECgraph, flag, TF1* fErrQuad);  
      fitResponse( RjetVsEdetMedianGraph[fi][0], RjetVsEdetMedianGraph[fi][1], RjetVsEdetMedianGraph[fi][2], 
		   flag, covarquad, fErrQuad);  

  }//loop over files



  
  TBrowser *bbb = new TBrowser("QitekBrowser","Qitek's amazing and multipurpose TBrowser object:)",600,200,400,500);
  
#ifndef _CINT_
  theApp.Run();
#endif 
  
}




