/*
 *   File:      mydrawtools.cpp
 *   Purpose:   My draw tools and routines
 *   Author:    Jiri Kvita 
 *   Created:   Aug 28 2004
 *   Modified:  $Id: mydrawtools.cpp,v 1.5 2004/10/04 02:11:47 kvita Exp $
 */

#include <TCanvas.h>
#include "mydrawtools.hpp"
#include <TH2F.h>
#include <TH1F.h>
#include <TProfile.h>
#include <TGraphErrors.h>
/*
//------------------------------------------------------------------------
bool TMyCanvas::DrawMe()
{
return fDrawMe;
}
//------------------------------------------------------------------------
int  TMyCanvas::DivideMe()
{
  Divide(fdivx,fdivy);
}
//------------------------------------------------------------------------
TMyCanvas::TMyCanvas(const char* name, const char* title, int wtopx, int wtopy, int ww, int wh, bool DrawMe=1, int divx=1, int divy=1)
{
  TMyCanvas(const char* name, const char* title, int wtopx, int wtopy, int ww, int wh);
  fDrawMe=DrawMe;
  fdivx=divx;
  fdivy=divy;
}
//------------------------------------------------------------------------
*/

//------------------------------------------------------------------------
bool TMyCanvasAttributes::GetDrawMe()
{
  return fDrawMe;
}
//------------------------------------------------------------------------
int TMyCanvasAttributes::GetDivisionX()
{
  return fdivx;
}
//------------------------------------------------------------------------
int TMyCanvasAttributes::GetDivisionY()
{
  return fdivy;
}
//------------------------------------------------------------------------ 
char* TMyCanvasAttributes::GetName()
{
  return fname;
}
//------------------------------------------------------------------------
TMyCanvasAttributes::TMyCanvasAttributes(const char* name, bool DrawMe, int divx, int divy)
{
  fname = new char[strlen(name)+1];
  strcpy(fname, name);
  fdivx = divx;
  fdivy = divy;
  fDrawMe = DrawMe;
}
//------------------------------------------------------------------------

// ----------------------------------------------------------------
void SetDataStyle(TH1F *h)
{
  if (h) {
    h->SetMarkerStyle(8);
    h->SetMarkerSize(0.8);
    h->SetMarkerColor(9);
    h->Rebin(4);
  }
}
// ----------------------------------------------------------------
void SetMCStyle(TH1F *h)
{
  if (h) { 
    h->SetLineWidth(1);
    h->SetLineStyle(0);
    h->SetLineColor(2);
    h->Rebin(4);
  }
}

// ----------------------------------------------------------------
void  SetHistoStyle(TH1F* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle)
{
 if (histo) {
   histo->UseCurrentStyle();
   histo->SetMarkerColor(col);
   histo->SetMarkerStyle(marker);
   histo->SetMarkerSize(markerSize);
   histo->SetXTitle(xtitle);
   histo->SetYTitle(ytitle);
   histo->SetLineWidth(1);
   histo->SetDrawOption("e1");
   
   //  histo->GetXaxis()->SetLabelSize(0.06);
   //histo->GetYaxis()->SetLabelSize(0.06);
   //histo->SetTitleSize(0.06);
   //histo->SetTitleSize(0.06);
 }
}
// ----------------------------------------------------------------
void  SetHistoStyle(TH1F* histo,char* xtitle, char* ytitle)
{
  if (histo) {
    histo->SetXTitle(xtitle);
    histo->SetYTitle(ytitle);
  }
}
// ----------------------------------------------------------------
void  SetHistoStyle(TH1F* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle,float ymin,float ymax)
{
 if (histo) {
   SetHistoStyle(histo,col,marker,markerSize,xtitle,ytitle);
   histo->SetMaximum(ymax);
   histo->SetMinimum(ymin);
 }
}
// ----------------------------------------------------------------
void  SetHistoStyle(TProfile* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle)
{
  if (histo) {
    histo->UseCurrentStyle();
    histo->SetMarkerColor(col);
    histo->SetMarkerStyle(marker);
    histo->SetMarkerSize(markerSize);
    histo->SetLineWidth(1);
    histo->SetDrawOption("e1");
    SetHistoStyle(histo,xtitle,ytitle);
  }
}
// ----------------------------------------------------------------
void  SetHistoStyle(TProfile* histo,char* xtitle, char* ytitle)
{
 if (histo) {
   histo->SetXTitle(xtitle);
   histo->SetYTitle(ytitle);
 }
}
// ----------------------------------------------------------------
void  SetHistoStyle(TProfile* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle,float ymin,float ymax)
{
  if (histo) {
    SetHistoStyle(histo,col,marker,markerSize,xtitle,ytitle);
    histo->SetMaximum(ymax);
    histo->SetMinimum(ymin);
  }
}

// ----------------------------------------------------------------
void  SetHistoStyle(TH2F* histo,int col,int marker,float markerSize,char* xtitle, char* ytitle)
{
  if (histo) {
    histo->UseCurrentStyle();
    histo->SetMarkerColor(col);
    histo->SetMarkerStyle(marker);
    histo->SetMarkerSize(markerSize);
    SetHistoStyle(histo,xtitle,ytitle);
  }
}
//------------------------------------------------------------------------
void SetHistoStyle(TH2F* histo,char* xtitle, char* ytitle)
{
  if (histo) {
    histo->SetXTitle(xtitle);
    histo->SetYTitle(ytitle);
  }
}
// ----------------------------------------------------------------
void SetGraphStyle(TGraphErrors* graph,int col,int marker,float markerSize,char* xtitle, char* ytitle)
{
  if (graph) {
    graph->UseCurrentStyle();
    graph->SetMarkerColor(col);
    graph->SetMarkerStyle(marker);
    graph->SetMarkerSize(markerSize);
    SetGraphStyle(graph,xtitle,ytitle);
  }
}
//------------------------------------------------------------------------
void SetGraphStyle(TGraphErrors* graph,char* xtitle, char* ytitle)
{
  if (graph) {
    graph->GetXaxis()->SetTitle(xtitle);
    graph->GetYaxis()->SetTitle(ytitle);
  }
}//------------------------------------------------------------------------

