#!/bin/sh

set -o errexit

declare -a CCFLAGS=(
    #
    # Warning Options
    -Wunknown-pragmas
    -Wall -W 
    #-Wundef -Wshadow -Wpointer-arith -Wbad-function-cast -Wcast-qual
    #-Wcast-align -Wwrite-strings -Waggregate-return
    #-Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations
    #-Wmissing-noreturn
    #-Wnested-externs -Winline
    -Werror
    #
    # Debugging Options
    -ggdb3 -save-temps
    #-g0
    #
    # Optimize Options
    # -O3 -fforce-addr -fomit-frame-pointer -funroll-loops
    -O0
    #
    # miscellanea
    -D_GNU_SOURCE
    "$@"
)
echo -e "\nCommon compiling options\n${CCFLAGS[*]}\n"

echo 'Compiling dynalib.o ...'
gcc ${CCFLAGS[*]} -c dynalib.c
echo 'Linking dynalib-norootlib.exe ...'
gcc -Wl,-rpath,. -ldl -o dynalib-norootlib.exe dynalib.o
echo 'Linking dynalib-rootlib.exe ...'
gcc -Wl,-rpath,. `root-config --libs` -o dynalib-rootlib.exe dynalib.o

echo 'Compiling myclass-nodict.o ...'
g++ ${CCFLAGS[*]} -fPIC -c -DNO_USE_DICT -o myclass-nodict.o myclass.cxx
echo 'Linking myclass-nodict-norootlib.so ...'
g++ -shared -Wl,-soname,myclass-nodict-norootlib.so \
    -o myclass-nodict-norootlib.so myclass-nodict.o 
echo 'Linking myclass-nodict-rootlib.so ...'
g++ -shared -Wl,-soname,myclass-nodict-rootlib.so `root-config --libs` \
    -o myclass-nodict-rootlib.so myclass-nodict.o 

echo 'Compiling myclass-dict.o ...'
g++ ${CCFLAGS[*]} -fPIC -c `root-config --cflags` -o myclass-dict.o myclass.cxx
echo 'Creating myclassDict.cxx ...'
rootcint -f myclassDict.cxx -c myclass.h
echo 'Compiling myclassDict.o ...'
g++ ${CCFLAGS[*]} -fPIC -c `root-config --cflags` myclassDict.cxx
echo 'Linking myclass-dict-norootlib.so ...'
g++ -shared -Wl,-soname,myclass-dict-norootlib.so \
    -o myclass-dict-norootlib.so myclass-dict.o myclassDict.o
echo 'Linking myclass-dict-rootlib.so ...'
g++ -shared -Wl,-soname,myclass-dict-rootlib.so `root-config --libs` \
    -o myclass-dict-rootlib.so myclass-dict.o myclassDict.o

echo -e '\nDone!\n'

