#ifndef SINGLETON_H
#define SINGLETON_H

#include <iostream>

using namespace std;

template <class T>
class Singleton
{
  static Singleton<T>* instance;
  Singleton() {}
 public:
  void DoIt() { cout<<__PRETTY_FUNCTION__<<endl;}
  static Singleton& Instance()
  {  
    if(!instance)
      instance = new Singleton<T>();
    return *instance;
  }
};

// Here's the bug
// If this isn't hidden from rootcint, the build fails
#ifndef __CINT__
template <class T>
Singleton<T>* Singleton<T>::instance = 0;
#endif

#endif
