#include <TROOT.h>
#include <TH1.h>
#include <TFile.h>
#include <TSpectrum.h>
#include <fstream.h>
#include <TCanvas.h>

void TSpectrum_loop_3( bool plot_it )

{

  cout << "This macro creates an array of TSpectrum objects." << endl;

  TFile *f = new TFile("ten_histograms.root");
  TH1F *hsearch;

  Int_t nhist = 10;
  Int_t nfound;

  TSpectrum *peak_search = new TSpectrum[nhist];
  Float_t *xpeaks;
  Double_t sigma = 1.248;

  TCanvas *c1;

  if ( plot_it == true ) {
    c1 = (TCanvas*)gROOT->FindObject("c1");
    if ( c1 ) {
      c1->Clear();
    }
    else {
      c1 = new TCanvas( "c1","",400,400);
    }
  }

  for ( Int_t i = 0; i < nhist; i++ ) {

    char histname[10];
    sprintf( histname, "h%d", i );
    hsearch = (TH1F*)gROOT->FindObject(histname);

    if ( hsearch == NULL ) {
      cout << "can't find histogram number " << i << endl;
      return;
    }


    peak_search[i].SetResolution(1.0);

    if ( plot_it == true ) {
      nfound = peak_search[i].Search(hsearch,sigma,"",0.05);
    }
    else {
      nfound = peak_search[i].Search(hsearch,sigma,"goff",0.05);
    }
    xpeaks = peak_search[i].GetPositionX();

    cout << "In histogram number " << i << ", found " 
	 << nfound << " peaks" << endl;
    for ( Int_t j = 0; j < nfound; j++ ) {
      cout << "\txpeak = " << xpeaks[j] << endl;
    }
   
    if ( plot_it == true ) {
      c1->Update();
      cout << "c to continue, or q to quit" << endl;
      char c;
      c = getchar();
      while ( c != 'q' && c != 'c' ) {
        c = getchar();
      }
      if ( c == 'q' ) return;
    }

  }

  delete xpeaks;
  delete [] peak_search;
  delete hsearch;
  f->Close();

}
    
