#include <TROOT.h>
#include <TFile.h>
#include <TTree.h>
#include <TRandom.h>
#include <fstream.h>

void make_tree()

{

  Int_t split   = 99;     // split level for ROOT tree
  Int_t bufsize = 32000; // buffer size before autosave
  Int_t comp    = 0;      // compression level of ROOT file

  // create ROOT objects
  TFile *rootFile = new TFile("array_events.root","RECREATE");
  TTree *rootTree = new TTree("tree","a few arrays");
  Event *event = new Event();

  rootTree->Branch("event_branch", "Event", &event, bufsize,split);
  rootFile->SetCompressionLevel(comp);

  Int_t nevent = 100;
  Int_t run = 1;
  Int_t array_length = 40;
  Int_t *array_data = new Int_t[array_length];
  Int_t num_arrays;

  for ( Int_t i = 0; i < nevent; i++ ) {
  
    event->clear();
    event->set_ne(i);
    event->set_nr(run);

    num_arrays = (Int_t)(10*gRandom->Rndm());

    for ( Int_t j = 0; j < num_arrays; j++ ) {

      for ( Int_t k = 0; k < array_length; k++ ) {
	array_data[k] = (Int_t)(100*gRandom->Rndm());
      }
  
      MyArray array(array_length,array_data);
      event->add_array( array );

    }  

    rootTree->Fill();

  }

  rootTree->Write();
  rootFile->Close();

}
