#ifndef Event_h
#define Event_h

#include "TObject.h"
#include "TClonesArray.h"

class TDirectory;
class MyArray;

class Event : public TObject {

private:

  Int_t nr;          // Run number
  Int_t ne;          // Event number
  Int_t narray;     // number of MyArray objects
   
  TClonesArray *arrays;   
  static TClonesArray *garrays;

public:
  Event();
  virtual ~Event();
  void          clear(Option_t *option ="");
  static void   Reset(Option_t *option ="");
  void          set_nr(Int_t n) { nr = n; }
  void          set_ne(Int_t n) { ne = n; }
  void          add_array( MyArray & arr );

  Int_t         get_nr() const { return nr; }
  Int_t         get_ne() const { return ne; }
  Int_t         get_narray() const { return narray; }
  TClonesArray *get_arrays() const { return arrays; }
  ClassDef(Event,1)  //Event structure

};


class MyArray : public TObject {

private:

  Int_t    nlen;
  Int_t    *data; //[nlen]

public:

  MyArray( MyArray & ARRAY );
  MyArray();
  MyArray( Int_t NLEN, Int_t * DATA );
  virtual ~MyArray() { }

  Int_t    get_nlen();
  Int_t*    get_data();

  ClassDef(MyArray,1) 
};

#endif


