/////////////////////////////////////////////////////////////
//
//  tree that has branch that is a class which contains
//     a TClonesArray
//
////////////////////////////////////////////////////////////


#include <math.h>
#include <iostream>

#include "TROOT.h"
#include "TFile.h"
#include "TTree.h"
#include "TRandom.h"
#include "TSystem.h"
#include "TH1.h"


#include "foo_Cint.h"


using namespace std;


int main(int argc, char *argv[]) 
{

	Bar *pBar ;
	Foo *pFoo = new Foo();
	TClonesArray pMod("Bar", maxModules) ;

	pFoo->modules = &pMod ;

	TFile ofitFile("xxxxx.root", "recreate");
	TTree *tree = new TTree("tree","data from multiple modules");

	tree->Branch("foo", "Foo", &pFoo);
	for(Int_t iev=0; iev<10; iev++) {

		Int_t nmod;

		nmod = (Int_t) floor( 4 * gRandom->Rndm(1) ) ;

		pFoo->iEv  = iev  ;
		pFoo->nMod = nmod ;

		cout << "iEv = " << iev << ",\t nMod = " << nmod << endl;

		for(Int_t im=0; im<nmod; im++) {

			new(pMod[im]) Bar() ;
			pBar = (Bar *) pMod[im] ;
			Int_t ntow;
			ntow = (Int_t) ( 10 + floor ( 10 * gRandom->Rndm(1) ) ) ;
			pBar->nTow = ntow ;
			for(Int_t it=0; it<ntow; it++) {
				pBar->adc[it] = 100 * gRandom->Rndm(1) ;
			}

		}

		tree->Fill();

		pMod.Delete();

	}

	ofitFile.Write();
	ofitFile.Close();

	Bar * pBar2  ;
	Foo * pFoo2 = new Foo() ;
	TClonesArray pMod2("Bar", maxModules) ;
	pFoo2->modules = &pMod2 ;

	TFile fHist("fHist.root", "Recreate");
	TH1F *h1 = new TH1F("h1", "h1", 100, 0, 100);

	TFile f("xxxxx.root");
	TTree *ntree = (TTree *) f.FindObjectAny("tree");
	ntree->SetBranchAddress("foo",&pFoo2);

	Int_t nentries = (Int_t) ntree->GetEntries();

	cout << "nentries = " << nentries << endl;

	for (Int_t i=0;i<nentries;i++) {

		ntree->GetEntry(i);

		Int_t nmod = pFoo2->nMod ;

		cout << "i = " << i << ",\t nMod = " << nmod << endl;

		if( nmod > 0 ) {
			pBar2 = (Bar *) pFoo2->modules->First() ;
			h1->Fill(pBar2->adc[0]);
		}

	}

	f.Close();
	fHist.Write();
	fHist.Close();

	return 0;

}
