#include <iostream>
#include <iomanip>
#include <fstream>
#include <cstdlib>
#include "TApplication.h"
#include "TFile.h"
#include "TTree.h"

#include "A.h"


int main(int argc,char** argv) {

  TApplication theApp("App", &argc, argv);
  gApplication->Init();

  argc=theApp.Argc();
  argv=theApp.Argv();

  //clonedummy input.root output.root
  if(argc!=2) {
    std::cout << "Argument Error!" << std::endl;
    std::exit(1);
  }

  std::cout << "Output  file : " << argv[1] << std::endl;

  TFile* tfo = new TFile(argv[1],"RECREATE");
  TTree* tree = new TTree("tree","test");
  
  A*   a = new A();

  tree->Branch("A","A",&a);

  for (Int_t jentry=0; jentry<10;jentry++) {
    a->Fill(jentry+1);
    
    tree->Fill();
  }
  tree->Write();
  tfo->Close();

  return 0;
}
