# include <cmath>
# include <iostream>
# include "TVirtualFitter.h"
# include "MinuitTest.h"

MinuitTest::MinuitTest() {
}

MinuitTest::~MinuitTest() {
}

void MinuitTest::RunIt() { 

  TVirtualFitter *minuit = TVirtualFitter::Fitter(0, 2);
  minuit->SetFCN(fcn);         // <== This goes through compiler now              

  FcnClass* anObjectOfFcnClass;           
  minuit->SetObjectFit(anObjectOfFcnClass);  // <== This doesn't

  minuit->SetParameter(0, "alpha1",    20,     0.1, 0,0);
  minuit->SetParameter(1, "alpha2",    20,     0.1, 0,0);
  Double_t arglist[100];
  arglist[0] = 1;
  minuit->ExecuteCommand("CALL FCN", arglist, 1);
  minuit->FixParameter(2);
  arglist[0] = 0;
  minuit->ExecuteCommand("SET PRINT", arglist, 1);
  minuit->ExecuteCommand("MIGRAD", arglist, 0);
  minuit->ExecuteCommand("MINOS", arglist, 0);
  minuit->ReleaseParameter(2);
  minuit->ExecuteCommand("MIGRAD", arglist, 0);
  minuit->ExecuteCommand("MINOS", arglist, 0);
  arglist[0] = 3;
  minuit->ExecuteCommand("CALL FCN", arglist, 1);
}
