# include <cmath>
# include <iostream>
# include "TVirtualFitter.h"
# include "MinuitTest.h"

MinuitTest::MinuitTest() {
}

MinuitTest::~MinuitTest() {
}

void MinuitTest::RunIt() { 
  TVirtualFitter *minuit = TVirtualFitter::Fitter(0, 2);
  minuit->SetFCN(fcn);
  minuit->SetParameter(0, "alpha1",    20,     0.1, 0,0);
  minuit->SetParameter(1, "alpha2",    20,     0.1, 0,0);
  Double_t arglist[100];
  arglist[0] = 1;
  minuit->ExecuteCommand("CALL FCN", arglist, 1);
  minuit->FixParameter(2);
  arglist[0] = 0;
  minuit->ExecuteCommand("SET PRINT", arglist, 1);
  minuit->ExecuteCommand("MIGRAD", arglist, 0);
  minuit->ExecuteCommand("MINOS", arglist, 0);
  minuit->ReleaseParameter(2);
  minuit->ExecuteCommand("MIGRAD", arglist, 0);
  minuit->ExecuteCommand("MINOS", arglist, 0);
  arglist[0] = 3;
  minuit->ExecuteCommand("CALL FCN", arglist, 1);
}

void MinuitTest::fcn(Int_t &npar, Double_t *gin, Double_t &f, Double_t *par, Int_t iflag) {
  const Int_t n = 5;
  Double_t y[n] = {12, 32, 45, 67, 78};
  Double_t x[n] = {1, 2, 4, 6, 8};
  Double_t chisq = 0.;
  for (int i = 0; i < n; i++) {
    chisq += pow(y[i]-par[0]*x[i]-par[2]/x[i],2);
  }
  f = chisq;
}
