# include <cmath>
# include <iostream>
# include "TMinuit.h"
# include "MinuitTest.h"

MinuitTest::MinuitTest() {
}

MinuitTest::~MinuitTest() {
}

void MinuitTest::RunIt() { 
  TMinuit *gMinuit = new TMinuit(5);
  gMinuit->SetFCN(fcn);                // <=== THIS DOES NOT WORK
  Double_t arglist[10];
  Int_t ierflg = 0;
  arglist[0] = 1;
  gMinuit->mnexcm("SET ERR", arglist ,1,ierflg);  
  // Set starting values and step sizes for parameters
  static Double_t vstart[2] = {20, 20};
  static Double_t step[2] = {0.0001 , 0.0001};
  gMinuit->mnparm(0, "alpha1", vstart[0], step[0], 0, 0, ierflg);
  gMinuit->mnparm(1, "alpha2", vstart[1], step[1], 0, 0, ierflg);
  arglist[0] = 500;
  arglist[1] = 1.;
  gMinuit->mnexcm("MIGRAD", arglist, 2, ierflg);
  //PRINT MINUIT'S RESULTS
  Double_t amin,edm,errdef;
  Int_t nvpar,nparx,icstat;
  gMinuit->mnstat(amin,edm,errdef,nvpar,nparx,icstat);
  gMinuit->mnprin(3,amin);
  //Get the result from minuit 
  Double_t perrors[6], params[6];
  gMinuit->GetParameter(0,params[0], perrors[0]);
  gMinuit->GetParameter(1,params[1], perrors[1]);
  cout<<"params[0] = alpha1 = "<<params[0]<<" params[1] = alpha2 = "<<params[1]<<endl;
}

void MinuitTest::fcn(Int_t &npar, Double_t *gin, Double_t &f, Double_t *par, Int_t iflag) {
  f = chisquare(par[0], par[1]);
}

double MinuitTest::chisquare(Double_t alpha1, Double_t alpha2) {
  const Int_t n = 5;
  Double_t y[n] = {12, 32, 45, 67, 78};
  Double_t x[n] = {1, 2, 4, 6, 8};
  Double_t chisq = 0.;
  for (int i = 0; i < n; i++) {
    chisq += pow(y[i]-alpha1*x[i]-alpha2/x[i],2);
  }
  return chisq;
}
