#include <iostream>
#include <iomanip>
#include <fstream>
#include <cstdlib>
#include "TApplication.h"
#include "TFile.h"
#include "TTree.h"

#include "A.h"


int main(int argc,char** argv) {

  TApplication theApp("App", &argc, argv);
  gApplication->Init();

  argc=theApp.Argc();
  argv=theApp.Argv();

  if(argc!=2) {
    std::cout << "Argument Error!" << std::endl;
    std::exit(1);
  }

  std::cout << "Input  file : " << argv[1] << std::endl;

  A*   a = new A();
  
  TFile* tfi = new TFile(argv[1],"READ");
  TTree* tree = (TTree*)tfi->Get("tree");
  
  tree->SetBranchAddress("A",&a);

  Int_t nevent = Int_t(tree->GetEntries()); 

  for (Int_t jentry=0; jentry<nevent;jentry++) {

   Int_t ientry = tree->LoadTree(jentry);
   if (ientry < 0) break;
   tree->GetEntry(jentry);
   a->Dump();
  }
  tfi->Close();

  delete a;
  
  return 0;
}
