#ifndef NAZDCDIGIT_H
#define NAZDCDIGIT_H

#include "NaDigit1D.h"

class NaZDCDigit : 
public NaDigit1D {
  //
 public:
  enum {kNQuadrants=4,kNBlade=3,kNPileUp=24,kNTrigPU=8};
 protected:
  //
  Float_t fSignal[kNQuadrants];		// ZDC signals
  Float_t fSignalSum;	        	// ZDC hardware sum
  Float_t fPedestal[kNQuadrants];	// Off-time signals
  Float_t fBlade[kNBlade];		// Off-time signals
  Float_t fPileUpPort[kNPileUp];	// Ports for Pile-Up
  Float_t fTrigPU[kNTrigPU];		// Trigger P.U.
  //
  //
  ClassDef(NaZDCDigit,4) // NA60 ZDC Digit
};

#endif

