// Author: Ruben Shahoyan

//////////////////////////////////////////////////////////////////////////
//                                                                      //
//                      NA60 Particle Class                             //
//                                                                      //
//                Adds to TParticles following features                 //
// 1.List of pointers on the digits this particle has generated         //
//   (they are not written in the tree, but recovered from the digit's  //
//   references after reading event back)                               //
// 2.Index of this particle in the MCEvent (written in the tree and     //
//   updated each time particle is changes its position in the MCEvent) //
// 3.UniqueID member contains:                                          //
//   Byte 1    : contains the keyword for the mechanism this particle   //
//   was produced with (defined in NaMCProcess.h)                       //
//   Byte 3    : contains index of MC event header currently stored     //
//   in the MCEvent, to which this particle belongs.                    //
//   Byte 4    :  if this particle was considered as an interesting one //
//   and refered in the fIndices array of the MCEvent, then it contains //
//   the index+1 of the element of the fIndices array refering to it.   //
// 4.fBits memder contains the bit pattern of different flags showing   //
//   the status of the particle (defined in NaMCEvent)                  //
//                                                                      //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#ifndef NAPARTICLE_H
#define NAPARTICLE_H

#include "TObject.h"
#include "TParticle.h"
#include "TList.h"
#include "TParticlePDG.h"
#include "TPolyLine3D.h"
class NaDigit1D;

class NaParticle : 
public TParticle {
  //
 protected:
  TList   fDigits;         //! list of the digits references, updated after reading of digits
  Int_t fNumber;           //  Index in the MCEvent particles list
  //
  TPolyLine3D* fImage;     //! Aux. Image for drawing
  //
  ClassDef(NaParticle,1)  // NA60 Particle Class 
};

#endif
