// Author: Ruben Shahoyan

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//        MC Event header: describes basic features of the event             //
//        and its generation purpose (Id of the process to study)            //
//                                                                           //
// Containes the primary vertex information, basic information from          //
// the MC generator (impact parameter, number of particles generated etc.)   //
// and number of particles stored in the MC event                            //
// Depending on the MC Process ID, the elements of the fIndices array        //
// contain the indices of interesting particles (maximum fgkMaxIndex)        //
// This information is used by the NaMCEvent class for managing effective    //
// tracking.                                                                 //
//                                                                           //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#ifndef NAMCHEADER_H
#define NAMCHEADER_H

#include "TObject.h"
#include "NaVertexPrim.h"
class NaParticle;
class NaMCEvent;
 
class NaMCHeader : 
public  TObject {
 protected:
  //
  static const Int_t  fgkMaxIndex = 20;
  //
  NaVertexPrim  fVertex;                      //Primary Vertex
  Int_t         fProcessId;                   //Id of the MC Process Type
  Int_t         fNIndices;                    //Number of interesting indices stored (dep.on process)
  Int_t         fIndices[fgkMaxIndex];        //Index of the interesting particle in the MCEvent
  Float_t       fValues[fgkMaxIndex];         //Optional Values
  Float_t       fWeight;                      //Overall Event Weight
  // Generator data
  Float_t       fImpactParam;                 //Impact parameter in fm
  Int_t         fNPrimaries;                  //Total Number of primaries (from MC Generator)
  Int_t         fNSecondaries;                //Total Number of secondaries (from MC Generator)
  Int_t         fNStored;                     //Number of particles stored in the MCEvent

  Int_t         fPrimSpect;                   //Number of primary spectators
  Int_t         fPrimPart;                    //Number of primary participants
  Int_t         fNumColl;                     //Number of collisions

  Float_t       fACMCurr;                     //Current in ACM used to generate this event
  Float_t       fPT7Curr;                     //Current in PT7 used to generate this event
  //
  ClassDef(NaMCHeader,3) //NA60 MC event header    
};

#endif
