// Author : Ruben Shahoyan

//////////////////////////////////////////////////////////////////////////
//                                                                      //
//                      NA60 Basic Digit Class                          //
//                                                                      //
// Digit1D represents a 1Dimensional hit in abstract sensor (i.e.       //
// strip, slab, wire etc.). The hits for 2D sensors should be derived   //
// from NaDigit1D by adding extra dimension.                            //
// It has a following features:                                         //
// 1.When used in MC run, it keeps the references on all particles      //
//   which contributed to given digit (in turn, NaParticle particles    //
//   refer to digits.                                                   //
// 2.Apart from the sensor response value, class contains in packed     //
//   form the NaElem ID of the sensor (its volume number) and the       //
//   index of the digit in the array of digits for this sensor          //
//   (word1 and word2 respectively of fUniqueID data member of          //
//   NaDigit1D.                                                         //
// 3.It keeps the index of the cluster to which it was attached         //
//                                                                      //
// All NaSensor derived sensors should define their own digits          //
// derived from NaDigit1D. This new digit class should provide at       //
// least:                                                               //
// 1) Copy constructor:    NaXXXDigit(const NaXXXDigit& dig)            //
//                                    : NaDigit1D(dig) { assignments }  //
// 2) Normal constructor:  NaXXXDigit(Int_t val, other values )         //
//                                    : NaDigit1D(val) { assingments }  //
// 3) If they have more values than fI of NaDigit1D, the methods for    //
//    comparison: IsEqual() and Compare() (if these values are relevant)//
//                                                                      //
//                                                                      //
// The user has possibility to store into the digit track position and  //
// energy in the middle of the sensor. For that one should uncomment    //
// #define STOREFULLINFO. Note: if 2 digits overlapped, the info of the //
// first one will be kept only!                                         //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
#ifndef NADIGIT1D_H
#define NADIGIT1D_H

#define STOREFULLINFO

#include "TObject.h"
#include "TArrayI.h"


class NaDigit1D : 
public TObject {
  //
 protected:
  Int_t fI;             // Value of the digit
  Int_t fCluster;       //! Number of the Cluster to which it is attached
  TArrayI* fTracks;     // Optional array of references on track
  //
#ifdef STOREFULLINFO
  Float_t fXYZE[4];
  ClassDef(NaDigit1D,4) // Base class for 1Dim digits with FULL TRACKING INFO
#else
  ClassDef(NaDigit1D,3) // Base class for 1Dim digits
#endif
};

#endif

