#ifndef NACOVMATRIX_H
#define NACOVMATRIX_H

#include "TObject.h"

#if ROOT_VERSION_CODE < ROOT_VERSION(4,00,2)
typedef double Double32_t;
#endif

class NaCovMatrix : 
public TObject {
 public:
  enum {kSINGULAR    ,    // matrix is singular
	kUNDEFINED   ,    // no information about the type
	kGENERAL     ,    // matrix is of general type
	kSYMPOSDEF   ,    // assumed to be filled (upper triangle) by Symm.and PosDef matri
	kDECOMPOSED_CHO,  // SYMPOSDEF already is decomposed
	kDECOMPOSED_LU,   // GENERAL already is decomposed
	kINVERTED,        // already was inverted
	kUNITY,           // Unity matrix
	kNTypes
  };
  enum {fgkMaxSize = 50};
  //
 protected:
  static const char fCStat[kNTypes][15];
  // 
  Int_t     fSize;   //   Size of the matrix
  Int_t     fSize2;  //   Number of elements (size^2) 
  Byte_t    fStatus; //   Current type and status of the matrix
  // -1  not defined
  // 0   original matrix was inverted
  // 1   Original symmetric matrix, lower triangle is not filled,
  //     assumed to be positive-definite, so one could use fast algorithms
  // 2   Sym.,pos-def matrix, already decomposed by Cholesky decomposition
  //     ready to be inverted
  // 11  not assumed to be symmetric and pos-def, all is filled
  // 12  already decomposed by LU decomposition, ready to be inverted
  //
  Double32_t*  fElements; //[fSize2] Elements
  Double32_t** fIndex;    //!  Pointers on rows
  //
  static Double32_t fBufferV[fgkMaxSize];//! auxillary vector buffer
  static Double32_t fBufferM[fgkMaxSize][fgkMaxSize];//! auxillary matrix buffer
  //
#if ROOT_VERSION_CODE < ROOT_VERSION(4,00,2)
  ClassDef(NaCovMatrix,10) //Covariance Matrix Class Double
#else
  ClassDef(NaCovMatrix,11) //Covariance Matrix Class Double32
#endif

};

#endif
