// Author: Ruben Shahoyan

//////////////////////////////////////////////////////////////////
//                                                              //
//              NA60 Primary Interaction Vertex Class           //
//                                                              //
//     Adds Interacted  target Id to basic vertex               //
//     as well as interacted beam particles X and Y slopes      //
//     at interaction Z.                                        //
//                                                              //
//////////////////////////////////////////////////////////////////
#ifndef NAVERTEXPRIM_H
#define NAVERTEXPRIM_H

#include "NaVertex.h"

class NaVertexPrim :
public NaVertex
{
 protected:
  //
  Int_t   fTrackId;// Id of the beam particle in the particle's list
  Int_t   fTgtId;  // Id of interacted target
  Float_t fSlopeX; // X Slope at vertex
  Float_t fSlopeY; // Y Slope at vertex
  //
  ClassDef(NaVertexPrim,3)  // NA60 Primary vertex class
};


#endif
