#ifndef FOO_H
#define FOO_H

#include "TObject.h"


const Int_t maxModules = 4 ;


class Bar : public TObject {

 public:

	Int_t   nTow;
	Float_t adc[30];

	Bar() {};
	~Bar() {};

	ClassDef (Bar, 1);

};

class Foo : public TObject {

 public:

	Int_t iEv;
	Int_t nMod;
	Bar **modules;    //[nMod]         : "nMod" of modules, each provides data of type "Bar"

	Foo() {
		iEv=0; nMod=0; modules = 0;
	};

	void Set(Int_t iev, Int_t nmod) {
           iEv = iev;
           nMod = nmod;
           if (modules) delete [] modules;
           modules = 0;
           if (!nmod) return;
           modules = new Bar*[nmod];
           for (Int_t i=0;i<nmod;i++) modules[i] = new Bar();
        }
        ~Foo() {
		if (!nMod) return;
                for (Int_t i=0;i<nMod;i++) delete modules[i];
                delete [] modules;
	};

	ClassDef (Foo, 1);
};

#endif
