
// Parent.cc
#include "Parent.hh"
#include "TClonesArray.h"
#include "TFile.h"
#include "TRandom.h"

#include <assert.h>
#include <string>
#include <strstream>
#include <Riostream.h>
#include <stdio.h>

using namespace std;

Parent::Parent(int ) {
// Open a file, and a tree
     newfile = new TFile("MoneyTree.root","RECREATE","Simple ROOT  Ntuple");
     MoneyTree = new TTree("T","MoneyTree");
// Add a branch for things
     CloneThing = new TClonesArray("Thing");
     MoneyTree->Branch("CloneThing",&CloneThing,32000,2);
     MoneyTree->Branch("numThings",&numThings,"numThings/I");
// Verify what we have constructed...
     newfile->ls();
     TObjArray * br = MoneyTree->GetListOfBranches();
     TIter i(br);
     cout << "-----------------------------------------------------" <<  
endl;
     cout << "Branches:" << endl;
     while( TBranch * b = (TBranch*)i()){
       cout << b->GetName() << " : " << b->GetTitle() << endl;
     }
     cout << "-----------------------------------------------------" <<  
endl;
}

Parent::Parent( )
{}
Parent::~Parent( )
{}

void Parent::HasDaughters()
{
   CloneThing->Clear();
   // make daughters
   *Triplet = new Daughter[3];
   Triplet[0] = new Daughter(0);
   Triplet[1] = new Daughter(35);
   Triplet[2] = new Daughter(56);

   // Daughters want things
   Triplet[0]->Reset();
   Triplet[1]->Reset();
   Triplet[2]->Reset();
   Triplet[0]->Want(100);
   Triplet[0]->Want(150);
   Triplet[2]->Want(100);

   // Parent checks what daughters want, puts entry in money tree
   numThings = 0;
   for(int nd=0; nd <3; nd++) {
     int wantCash =  Triplet[nd]->GotAThing;
     printf("Daughter %d wants %d things\n",nd, wantCash);fflush(stdout);
     // Tried to add the whole clone array: runs, but doesn't store  Things
     if (wantCash > 0) {
       CloneThing =  (TClonesArray*) Triplet[nd]->CloneThing->Clone();
       numThings += wantCash;
     }

//     // Also tried to add one at a time, can't get syntax right
//     for (int i = 0; i < wantCash; i++) {
//       MyThing = new  
//((*CloneThing)[numThings])Triplet[nd]->CloneThing->At(i);
//       numThings++;
//     }

   }
   MoneyTree->Fill();

   // The above steps may repeat, then the file closes
   MoneyTree->GetCurrentFile()->Write();
   MoneyTree->GetCurrentFile()->Close();
}
