#ifndef NADIGIT1D_H
#define NADIGIT1D_H

//#define STOREFULLINFO

#include <TObject.h>
#include <TArrayI.h>

class NaDigit1D : 
public TObject {
  //
 public:
  NaDigit1D();
  NaDigit1D(Int_t val);
  virtual ~NaDigit1D();
  virtual void Print(Option_t *opt="") const;
  //
  void SetIndexAndSensorID(Int_t ind,Int_t sens) {SetWords21(ind,sens);}
  Int_t GetSensorElemID()              const     {return GetWord1();}
  Int_t GetIndexInSensor()             const     {return GetWord2();}
  //
#ifdef STOREFULLINFO
  void     SetXYZE(Float_t x,Float_t y,Float_t z,Float_t e) {fXYZE[0]=x;fXYZE[1]=y;fXYZE[2]=z;fXYZE[3]=e;}
  void     SetXYZE(const Float_t* xyze) {for (int i=4;i--;) fXYZE[i]=xyze[i];}
  Float_t* GetXYZE()   const {return (Float_t*)fXYZE; };
  Float_t  GetEnergy() const {return fXYZE[3]; };
#endif
  //
 protected:
  // Just Set and Get Value for 2byte word in the UniqueID bytes
  enum { kWord1=0x0000ffff, kWord2=0xffff0000 };
  //
  Int_t  GetWord1() const     { return GetUniqueID()  & kWord1; }
  Int_t  GetWord2() const     { return GetUniqueID()>>16;}
  //
  void   SetWord1(Int_t val)  { SetUniqueID((~kWord1) & GetUniqueID() | (val & kWord1) ); }
  void   SetWord2(Int_t val)  { SetUniqueID((~kWord2) & GetUniqueID() | ((val<<16) & kWord2)); }
  void   SetWords21(Int_t w2,Int_t w1)  { SetUniqueID( (w2<<16) + w1); }
  //
 protected:
  Int_t fI;             // Value of the digit
  Int_t fCluster;       // Number of the Cluster to which it is attached
  TArrayI* fTracks;     // Optional array of references on track
  //
#ifdef STOREFULLINFO
  Float_t fXYZE[4];
  ClassDef(NaDigit1D,2) // Base class for 1Dim digits with FULL TRACKING INFO
#else
  ClassDef(NaDigit1D,1) // Base class for 1Dim digits
#endif
};



class NaPixDigit : 
public NaDigit1D {
 public:
  NaPixDigit() {}
  NaPixDigit(Int_t col,Int_t row);
  virtual  void   Print(Option_t* option="") const;
 protected:
  Int_t fCol;            // Column of the pixel (NaDigit1D::fI is row)
  //
  ClassDef(NaPixDigit,1) // NA60 Pixel Detector digit (single pixel)
};


#endif

