#include "TestDigit.h"
#include <TFile.h>
#include <TTree.h>
#include <TRandom.h>
#include <TClonesArray.h>
#include <TObjArray.h>

ClassImp(NaDigit1D)

//____________________________________________
NaDigit1D::NaDigit1D()
{ 
  fI = -1;
  fCluster = -1; 
  fTracks = 0; 
#ifdef STOREFULLINFO
  SetXYZE(0,0,0,0);
#endif
  //
}

//____________________________________________
NaDigit1D::NaDigit1D(Int_t val)
{ 
  fI = val;
  fCluster = -1;
  fTracks = 0; 
#ifdef STOREFULLINFO
  SetXYZE(0,0,0,0);
#endif
  //
}

//____________________________________________
NaDigit1D::~NaDigit1D()
{
  if (fTracks) delete fTracks;
  //
}

//____________________________________________
void NaDigit1D::Print(Option_t *opt) const
{
  printf("Row# %3d |  Digit#%2d of Sensor %d | In Clus# %2d, Track Ptr: %p |",fI,GetIndexInSensor(),GetSensorElemID(),fCluster,fTracks);
#ifdef STOREFULLINFO
  printf(" X: %4.1f Y: %4.1f Z: %4.1f E: %4.1f",fXYZE[0],fXYZE[1],fXYZE[2],fXYZE[3]);
#endif
  printf("\n");
}

//-------------------------------------------------------------------------------------------


ClassImp(NaPixDigit)
//________________________________________________________________
NaPixDigit::NaPixDigit(Int_t col, Int_t row)
  : NaDigit1D(row), fCol(col)
{ 
}
//____________________________________________
void NaPixDigit::Print(Option_t *opt) const
{
  printf("Col# %2d ",fCol);
  NaDigit1D::Print(opt);
}




//////////////////////////////////////////////////////////////////////////////////////////////

const Int_t kSplitLev = 0;
const Int_t kNSensors=2; // number of for sensors (TClonesArrays with digits) 
const Int_t kNTestEv=2;
TObjArray *Detector=0; // set of sensors
TFile* OutFile;
TFile* InpFile;
TTree* OutTree;
TTree* InpTree;

void InitDetector()
{
  if (Detector) return;
  Detector = new TObjArray(kNSensors);
  for (int i=0;i<kNSensors;i++) Detector->Add(new TClonesArray("NaPixDigit",10));  
}

void TestGen(const char* fname = "test0.root")
{
  InitDetector();
  OutFile = new TFile(fname,"RECREATE");
  OutTree = new TTree("digTree","digTree");
  OutTree->Branch("detBranch","TObjArray",&Detector,32000,kSplitLev);
  //
  // generate test events
  for (int iev=0;iev<kNTestEv;iev++) {
    printf("Event %d\n",iev);
    for (int isn=0;isn<kNSensors;isn++) {
      int ndig = gRandom->Integer(10);
      TClonesArray* sensor = (TClonesArray*)Detector->At(isn);
      sensor->Delete(); // clean old digits
      for (int id=0;id<ndig;id++) {
	NaPixDigit* dig = new((*sensor)[id]) NaPixDigit(iev*100+isn*10+id,gRandom->Integer(32));
	dig->SetIndexAndSensorID(id,isn);
	dig->Print();
      }
    }
    OutTree->Fill(); // save event
  }
  //
  OutTree->Write();
  delete OutTree;
  OutFile->Close();
  delete OutFile;
  //
}

void TestRead(const char* fname = "test0.root")
{
  InitDetector();
  InpFile = new TFile(fname);
  InpTree = (TTree*)InpFile->Get("digTree");
  InpTree->SetBranchAddress("detBranch",&Detector);
  //
  // read test events
  int nev = (int)InpTree->GetEntries();
  for (int iev=0;iev<nev;iev++) {
    printf("Event %d\n",iev);    
    InpTree->GetEntry(iev);
    Detector->Print();
  }
  //
  delete InpTree;
  InpFile->Close();
  delete InpFile;
  //
}


void TestReadWrite(const char* fnameIn = "test0.root",const char* fnameOut = "test1.root")
{
  InitDetector();
  InpFile = new TFile(fnameIn);
  InpTree = (TTree*)InpFile->Get("digTree");
  InpTree->SetBranchAddress("detBranch",&Detector);
  //
  OutFile = new TFile(fnameOut,"RECREATE");
  OutTree = new TTree("digTree","digTree");
  OutTree->Branch("detBranch","TObjArray",&Detector,32000,kSplitLev);
  //
  // read test events and write them into new fle
  int nev = (int)InpTree->GetEntries();
  for (int iev=0;iev<nev;iev++) {
    printf("Event %d\n",iev);
    InpTree->GetEntry(iev);
    Detector->Print();
    OutTree->Fill(); // save event    
  }
  //
  OutTree->Write();
  delete InpTree;
  delete OutTree;
  InpFile->Close();
  OutFile->Close();
  delete InpFile;
  delete OutFile;
  //
}

