// @(#)root/gl:$Id: TH3GL.h 33579 2010-05-19 12:43:08Z rdm $
// Author: Matevz Tadel 2007

/*************************************************************************
 * Copyright (C) 1995-2007, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

#ifndef ROOT_TH3GL
#define ROOT_TH3GL

#include "TGLPlot3D.h"
#include <TGLUtil.h>
#include <TGLAxisPainter.h>

class TGLRnrCtx;
class TH3;
class TAxis;

class TH3;

class TH3GL : public TGLPlot3D
{
private:
   TH3GL(const TH3GL&);            // Not implemented
   TH3GL& operator=(const TH3GL&); // Not implemented

protected:
   TH3                *fM;  // Model object dynamic-casted to TH2.

public:
   TH3GL();
   virtual ~TH3GL();

   virtual Bool_t SetModel(TObject* obj, const Option_t* opt=0);
   virtual void   SetBBox();

   virtual void DirectDraw(TGLRnrCtx & rnrCtx) const;

   // To support two-level selection
   // virtual Bool_t SupportsSecondarySelect() const { return kTRUE; }
   // virtual void ProcessSelection(TGLRnrCtx & rnrCtx, TGLSelectRecord & rec);

   ClassDef(TH3GL, 0); // GL renderer class for TH3.
};

#endif
