#! /bin/sh
#
# xrootd	Start/Stop the XROOTD daemon
#
# chkconfig: 345 20 80
# description: The xrootd daemon is used to as file server and starter of
#              the PROOF worker processes.
#
# processname: xrootd
# pidfile: /var/run/xrootd.pid
# config:

XROOTD=$ROOTSYS/bin/xrootd
XRDLIBS=@libdir@

# Source function library.
. /etc/init.d/functions

# Get config.
. /etc/sysconfig/network

# Get xrootd config
[ -f /etc/sysconfig/xrootd ] && . /etc/sysconfig/xrootd

# Configure the environment (optional)
[ ! -z "$XRDENVCONFIG" ] && [ -f "$XRDENVCONFIG" ] && . $XRDENVCONFIG

# Check that networking is up.
if [ ${NETWORKING} = "no" ]
then
	exit 0
fi

[ -x $XROOTD ] || exit 0

RETVAL=0
prog="xrootd"

start() {
        echo -n $"Starting $prog: "
        # Options are specified in /etc/sysconfig/xrootd .
        # See $ROOTSYS/etc/daemons/xrootd.sysconfig for an example.
        # $XRDUSER *must* be the name of an existing non-privileged user.
        export LD_LIBRARY_PATH=$XRDLIBS:$LD_LIBRARY_PATH
        daemon $XROOTD -b -l $XRDLOG -R $XRDUSER -c $XRDCF $XRDDEBUG
        RETVAL=$?
        echo
        [ $RETVAL -eq 0 ] && touch /var/lock/subsys/xrootd
        return $RETVAL
}

stop() {
	[ ! -f /var/lock/subsys/xrootd ] && return 0 || true 
        echo -n $"Stopping $prog: "
        killproc xrootd
        RETVAL=$?
        echo
        [ $RETVAL -eq 0 ] && rm -f /var/lock/subsys/xrootd
	return $RETVAL
}

# See how we were called.
case "$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  status)
	status xrootd
	RETVAL=$?
	;;
  restart|reload)
	stop
	start
	;;
  condrestart)
	if [ -f /var/lock/subsys/xrootd ]; then
            stop
            start
        fi
	;;
  *)
	echo  $"Usage: $0 {start|stop|status|restart|reload|condrestart}"
	exit 1
esac

exit $RETVAL
